<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>年费拆分到月管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active">账务明细</li>
	</ul>
	<form:form id="searchForm" modelAttribute="saAnnualSplit" action="${ctx}/cab/getCsvDetail" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/> 
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id="type" name="type" type="hidden" value="${saPaymentDetail.type }"/>
		<input id="startDate" name="startDate" type="hidden" value="${saPaymentDetail.startDate }"/>
		<input id="endDate" name="endDate" type="hidden" value="${saPaymentDetail.endDate }"/>
		<input id="chargeItemId" name="chargeItemId" type="hidden" value="${saPaymentDetail.chargeItemId }"/>
		<input id="chargeItemName" name="chargeItemName" type="hidden" value="${name }"/>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单号</th>
				<th>会员号</th>
				<th>业务编号</th>
				<th>单价</th>
				<th>数量</th>
				<th>付款金额</th>
				<th>付款时间</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="saPaymentDetail">
			<tr>
				<td>${saPaymentDetail.runningNumber }</td>
				<td>
					${saPaymentDetail.memberCode}
				</td>
				<td>${name }</td>
				<td>${saPaymentDetail.price }</td>
				<td>${saPaymentDetail.paymentNum }</td>
				<td>${saPaymentDetail.paymentMoney }</td>
				<td>
				<fmt:formatDate value="${saPaymentDetail.chargeDate }" pattern="yyyy-MM-dd HH:mm:ss"/></td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>