<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@ attribute name="id" type="java.lang.String" required="true" description="组件id" %>
<%@ attribute name="label" type="java.lang.String" required="true" description="组件label" %>
<%@ attribute name="fileId" type="java.lang.String" required="true" description="图片回显url" %>
<%@ attribute name="requestMapping" type="java.lang.String" required="true" description="图片上传服务分路径"%>
<%@ attribute name="successCallback" type="java.lang.String" required="false" description="文件上传成功的回调方法，有俩个参数(file,response),对应文件信息和服务器的反馈"%>
<link href="${ctxStatic}/cropper/cropper.min.css" rel="stylesheet"/>
<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
<style>
	.defaultButton {
		border:none;
		margin-top:45px;
		width:120px;
		margin-left: 28px;
		display: inline-block;
		height: 40px;
		border-radius: 8px;
		overflow: hidden;
		font-size: 14px;
		color: #fff;
		text-align: center;
		line-height: 40px;
		background-repeat: no-repeat;
		background: rgb(43, 174, 117);
	}
	.defaultButton:hover, .operationback:hover {
		background: rgb(50, 196, 135);
	}
	
	.imginput {
		width: 0 !important;
		height: 0 !important;
		overflow: hidden
	}
	.imgshow {
		width: 60px;
		height: 40px;
	}
	.defaultButton:active, .operationback:active {
		background: rgb(50, 196, 135);
		border: none;
	}
	.container-layer {
		 width: 620px;
		 height: 400px;
	 }
	 .container-layer-content{
	 	width:620px;
	 	padding-top:50px;
	 	overflow:hidden;
	 }
	 .container-layer-img{
	 	width:360px;
	 	height:240px;
	 	display:inline-block;
	 }
	 #photo {
		  max-width: 450px;
		  max-height: 300px;
		  width: 450px;
		  height: 300px;
	 }
	 .img-preview-area{
	 	width:200px;
	 	margin-left: 50px;
	 	vertical-align: top;
	 	display: inline-block;
	 }
	 .img-preview{
		width:180px;
		height:120px;
		margin-top:15px;
		overflow: hidden;
	 }
	 .imghidden{
		display: none;
	 }
	 .upload-label{
	 	min-width: 131px;
	 	z-index:999;
	 	cursor: pointer;
	 }
</style>
<script src="${ctxStatic}/cropper/Cropper3.1.3.min.js"></script>
<script src="${ctxStatic}/cropper/canvas-to-blob.js"></script>
<script type="text/javascript">
	$(document).ready(function() {
		initCropper${id}($('#photo${id}'),$('#${id}Input'));
	});
	var containerLayer${id},imgTargetNum${id},fileChange${id};
	//截图初始化方法
	var initCropper${id} = function (img, input) {
	    var $image = img;
	    var options = {
	        aspectRatio:3/2, // 纵横比
	        viewMode: 2,
	        dragMode: 'move', 
	        cropBoxResizable: true, 
	        responsive: false,
	        scalable: true,
	        minCanvasHeight: 360,
	        minCanvasWidth: 240,
	        autoCropArea:1,
	        preview: '.img-preview-${id}' // 预览图的class名
	    };
	    $image.cropper(options);
	    var $inputImage = input;
	    var uploadedImageURL;
	    if (URL) {
	        // 给input添加监听
	        fileChange${id} = function (event) {
	            var event = event || window.event||arguments[0];
	            //target 就是这个对象
	            target = event.srcElement||event.target;
	            imgTargetNum${id} = target.id;
	            //捕获页
	            containerLayer${id} = layer.open({
	                type: 1,
	                shade: false,
	                title: "裁剪图片", //不显示标题
	                content: $('.container-layer-${id}'), //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
	                area: ['700px', '450px'], //宽高
	                // cancel: function(){
	                //     layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', {time: 5000, icon:6});
	                // }
	            });
	
	            var files = target.files;
	            var file;
	            if (!$image.data('cropper')) {
	                return;
	            }
	            if (files && files.length) {
	                file = files[0];
	                // 判断是否是图像文件
	                if (/^image\/\w+$/.test(file.type)) {
	                    // 如果URL已存在就先释放
	                    if (uploadedImageURL) {
	                        URL.revokeObjectURL(uploadedImageURL);
	                    }
	                    uploadedImageURL = URL.createObjectURL(file);
	                    // 销毁cropper后更改src属性再重新创建cropper
	                    $image.cropper('destroy').attr('src', uploadedImageURL).cropper(options);
	                    $(event.target).val('');
	                } else {
	                    window.alert('请选择一个图像文件！');
	                }
	            }
	        }
	    } else {
	        $inputImage.prop('disabled', true).addClass('disabled');
	    }
	}
	//截图
	var crop${id} = function (item, event) {
	    layer.close(containerLayer${id});
	    var $image = $('#photo${id}');
	    $image.cropper('getCroppedCanvas', {
	        width: 900, // 裁剪后的长宽
	        height: 600
	    }).toBlob(function (blob) {
	        layer.load();
	        var formData = new FormData();
	        formData.append('file',blob);
	        $.ajax({
	            url: '${ctx}/sys/file/${requestMapping}',
	            type: 'POST',
	            data: formData,
	            dataType:'json',
	            contentType: false,
	            processData: false,
	            cache: false,
	            success: function (res){
	            	console.log(res);
	            	$("#${id}").val(res.id);
	                $("#${id}Show").attr("src",res.url);
	                $("#${id}Show").addClass("imgshow");
	            },
	            error: function (XMLHttpRequest, status, error) {
	                layer.msg('网络连接错误！', {icon: 5});
	            },
	            complete: function (XMLHttpRequest, TS) {
	                layer.closeAll('loading');
	            }
	        });
	    }, "image/jpeg", 0.95);
	}
	
  	function deleteImg${id}(){
         $("#${id}Show").attr("src","");
         $("#${id}Show").removeClass("imgshow");
         $("#${id}").val("");
	}
	function showImg${id}(){
	    var src = $("#${id}Show").attr("src");
	    if(src != ""){
		    parent.layer.open({
		        type: 1,
		        title: false,
		        area: ['900px','600px'],
		        closeBtn: 0,
		        skin: 'layui-layer-nobg', //没有背景色
		        shadeClose: true,
		        content: "<img style='width:900px;height:600px;' src='"+src+"'>"
		    });
	    }
	}
</script>
<div style="height:0;overflow:hidden;">
	<div class="container container-layer container-layer-${id}">
		<div class="container-layer-content">
			<div class="container-layer-img" >
				<img id="photo${id}" src="" />
			</div>
			<div class="img-preview-area">
				<div>
					<p>预览：</p>
					<div class="img-preview img-preview-${id}"></div>
				</div>
				<div>
					<button type="button" class="cropUpload defaultButton" onclick="crop${id}()" style="border:none;margin-top:45px;width:120px;margin-left: 28px;">确认裁剪并上传</button>
				</div>
			</div>
		</div>
	</div>
</div>
<c:if test="${not empty fileId}">
	<img id="${id}Show" src="${pageContext.request.contextPath}/api/v1/open/image/${fileId}" class="imgshow">
</c:if>
<c:if test="${empty fileId}">
	<img  id="${id}Show" src="">
</c:if>
<input type="hidden" id="${id}" name="${id}" value="${fileId}" />
<div class="layui-box layui-upload-button">
	<input id="${id}Input" name="${id}Input" onchange="fileChange${id}(event)" type="file" name="file" accept="image/*" class="layui-upload-file"/>
	<span class="layui-upload-icon upload-label">
		<i class="layui-icon"></i>${label}
	</span>
</div>
<span>
	<a class="btn btn-success" onclick="deleteImg${id}();">删除图片</a>
	<a class="btn btn-success" onclick="showImg${id}();">预览</a>
</span>
