package com.thinkgem.jeesite.modules.sys.utils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import com.thinkgem.jeesite.modules.sys.entity.Office;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.OfficeService;
import org.apache.shiro.SecurityUtils;

/**
 * 查询当前用户查询某一数据的数据权限范围，
 * 返回的是省市信息。
 * @author fanhuibin
 *
 */
public class DataPermissionUtil {
	private static final String DATA_PERMISSION = "data_permission";
	
	// 权限字符demo {“dog_breed_certified”:["杭州"],"show_apply":["杭州"]}
	private static String[] getPermissionString(String key){
		User user = UserUtils.getUser();
		String stringPermissions = "";
		if(UserUtils.getCache(DATA_PERMISSION) == null){
			OfficeService officeService = SpringContextHolder.getBean("officeService");
			Office office = officeService.get(user.getOffice().getId());
			stringPermissions = office.getDataPermission();
			UserUtils.putCache(DATA_PERMISSION, stringPermissions);
		}else{
			stringPermissions = (String) UserUtils.getCache(DATA_PERMISSION);
		}
		
		if(user.getOffice()!=null){
			
			if(stringPermissions==null || stringPermissions.trim().equals("")){
				return null;
			}else{
				JSONObject object = JSONObject.fromObject(stringPermissions);
				JSONArray array = object.getJSONArray(key);
				String[] s = new String[array.size()];
				for(int i=0;i<array.size();i++){
					s[i] = array.getString(i);
				}
				return s;
			}
		}
		return null;
	}
	
	/**
	 * 是否查询赛事比赛数据权限受限
	 */
	public static boolean isShowApplyDataLimited(){
		String[] permissions = getPermissionString("show_apply");
		if(permissions == null){
			return false;
		}
		else if(SecurityUtils.getSubject().isPermitted("apply:showApply:viewAllArea")){
			return false;
		}
		else{
			return true;
		}
	}
	
	/**
	 * 是否查询出生纸信息数据权限受限。
	 * @return
	 */
	public static boolean isBirthCertDataLimited(){
		String[] permissions = getPermissionString("dog_breed_certified");
		if(permissions == null){
			return false;
		}else{
			return true;
		}
	}
	
	/**
	 * 查询当前用户在出生纸中有权限的数据
	 * 按照狗主人所在的省信息决定
	 * @return 
	 */
	public static String[] getBirthCertPermission(){
		return getPermissionString("dog_breed_certified");
	}
	
	/**
	 * 查询当前用户在赛事报名中的数据权限
	 * 通过检查赛事的主办地点决定。
	 * @return
	 */
	public static String[] getShowApplyPermission(){
		return getPermissionString("show_apply");
	}

}
