/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只鉴定表Controller
 * @author lgl
 * @version 2016-08-09
 */
@Controller
@RequestMapping(value = "/subSystem/dogAppraisal")
public class SubDogAppraisalController extends BaseController {

	@Autowired
	private DogAppraisalService dogAppraisalService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	
	@ModelAttribute
	public DogAppraisal get(@RequestParam(required=false) String id) {
		DogAppraisal entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogAppraisalService.get(id);
		}
		if (entity == null){
			entity = new DogAppraisal();
		}
		//标记isFinishOrder字段
		entity.setIsFinishOrder(dogAppraisalService.getIsFinishOrder(entity));
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogAppraisal dogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogAppraisal> page = dogAppraisalService.findPage(new Page<DogAppraisal>(request, response), dogAppraisal);
		//标记isFinishOrder字段
		for(DogAppraisal po:page.getList()){
			po.setIsFinishOrder(dogAppraisalService.getIsFinishOrder(po));
			po.setBusinessState(dogAppraisalService.getBusinessState(po));
		}
		model.addAttribute("page", page);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		return "subSystem/"+getUrlByUserType()+"/dog/dogappraisal/dogAppraisalList";
	}
	
	@RequestMapping(value = "form")
	public String form(DogAppraisal dogAppraisal, Model model) {
		model.addAttribute("dogAppraisal", dogAppraisal);
		return "subSystem/"+getUrlByUserType()+"/dog/dogappraisal/dogAppraisalForm";
	}
}