package com.cku.schools.mrschool.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.RESTResponse;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.schools.mrschool.service.SchoolsPaymentService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 *user chaixueteng
 *2017年6月19日
 */
@Controller
@RequestMapping(value="/schools/payment")
public class SchoolsPaymentController extends BaseController{
	
	@Autowired
	private MemberService memberService;
	@Autowired
	private SchoolsPaymentService schoolsPaymentService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	private GroomerRegisterService groomerRegisterService;
	/**
	 * 账户充值
	 * @Author chaixueteng
	 * @2017年6月22日上午9:52:40
	 */
	@RequestMapping(value="recharge")
	public String recharge(PaymentOrder paymentOrder,HttpServletRequest request,HttpServletResponse response,RedirectAttributes redirectAttributes){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String memberCode = ti.getSchoolMemberCode();
		Member member = memberService.getByMemberCode(memberCode);
		String name = member.getName();
		String amount=paymentOrder.getAmount();
		String paymentWay="1";
		String id=null;
		try {
			id = memberService.recharge(memberCode,name,amount,paymentWay);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:/schools/schoolsAccountManagement/recharge";
		}
		return "redirect:/api/v1/open/alipay/pay/"+id;
	}
	
	
	/**
	 * 学校续费
	 * @Author chaixueteng
	 * @2017年6月22日上午9:52:40
	 */
//	@RequestMapping(value="schoolRenew")
//	public String schoolRenew(String memberCode,Model model,RedirectAttributes redirectAttributes){
//		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
//		List<PaymentOrderDetail> schoolPay = schoolsPaymentService.schoolRenew(memberCode);
//		String orderCode = schoolPay.get(0).getOrderCode();
//		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
//		String id = ti.getId();
//		TrainingInstitution tition = trainingInstitutionDao.get(id);
//		model.addAttribute("order", schoolPay);
//		model.addAttribute("ti", tition);
//		model.addAttribute("redUrl", "redirect:/schools/schoolsAccountManagement/account?id="+ti.getId());
//		model.addAttribute("orderId", paymentOrder2.getId());
//		return "schools/pay/paymentPage";
//	}
	
	/**
	 * 会员续费
	 * @Author chaixueteng
	 * @2016年10月17日上午11:12:44
	 */
	@RequestMapping(value="pay")
	public String pay(String memberCode,Model model,RedirectAttributes redirectAttributes){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		Member member = memberService.getByMemberCode(memberCode);
		//校验是否冻结
		if("1".equals(member.getFreezeFlag())){
			addMessage(redirectAttributes, "该会员已冻结,无法操作!");
			return "redirect:/schools/schoolsMember/list?repage";
		}
		List<PaymentOrderDetail> memberPay = schoolsPaymentService.MemberToOrder(memberCode);
		String orderCode = memberPay.get(0).getOrderCode();
		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
		String id = ti.getId();
		TrainingInstitution tition = trainingInstitutionDao.get(id);
		model.addAttribute("order", memberPay);
		model.addAttribute("ti", tition);
		model.addAttribute("redUrl", "redirect:/schools/schoolsMember/list?repage");
		model.addAttribute("orderId", paymentOrder2.getId());
		return "schools/pay/paymentPage";
	}
	
	/**
	 * 结业证书缴费
	 * @Author chaixueteng
	 * @2016年10月17日上午11:12:44
	 */
	@RequestMapping(value="DiplomaPay")
	public String DiplomaPay(String diplomaId,Model model,RedirectAttributes redirectAttributes){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		GroomerDiploma groomerDiploma = groomerDiplomaService.get(diplomaId);
		List<PaymentOrderDetail> diplomaPay = schoolsPaymentService.DiplomaToOrder(groomerDiploma.getMemberCode(),diplomaId);
		String orderCode = diplomaPay.get(0).getOrderCode();
		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
		String id = ti.getId();
		TrainingInstitution tition = trainingInstitutionDao.get(id);
		model.addAttribute("order", diplomaPay);
		model.addAttribute("ti", tition); 
		model.addAttribute("redUrl", "redirect:/schools/schoolsCourse/diplomaList?repage");
		model.addAttribute("orderId", paymentOrder2.getId());
		return "schools/pay/paymentPage";
	}
	
	
	@RequestMapping(value="groomerRegisterPay")
	public String groomerRegisterPay(String groomerRegisterId,Model model,RedirectAttributes redirectAttributes){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		
		GroomerRegister groomerRegister = groomerRegisterService.get(groomerRegisterId);
		List<PaymentOrderDetail> diplomaPay = schoolsPaymentService.groomerRegisterToOrder(groomerRegister.getMemberCode(),groomerRegisterId);
		String orderCode = diplomaPay.get(0).getOrderCode();
		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
		String id = ti.getId();
		TrainingInstitution tition = trainingInstitutionDao.get(id);
		model.addAttribute("order", diplomaPay);
		model.addAttribute("ti", tition); 
		model.addAttribute("redUrl", "redirect:/schools/schoolsGroomerRegister/groomerRegisterList?repage");
		model.addAttribute("orderId", paymentOrder2.getId());
		return "schools/pay/paymentPage";
	}
	
	
	
	/**
	 * 支付页(余额支付+支付宝支付)
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	@RequestMapping(value="paymentOrder")
	public String paymentOrder(HttpServletRequest request,HttpServletResponse response){
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		String redUrl = request.getParameter("redUrl");
		if ("25".equals(paymentWay)) {//余额缴费
			schoolsPaymentService.paymentSchoolsOrder(paymentWay,orderId);
			return redUrl;
		}
		return "redirect:/api/v1/open/alipay/pay/"+orderId;
	}
	/**
	 * 微信缴费
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	@MultiSubmit(timeout = 10)
	@RequestMapping(value="/paymentSchoolsOrderByWeixin" , method=RequestMethod.POST)
	@ResponseBody
	public void paymentClubOrderByWeixin(HttpServletRequest request,HttpServletResponse response)throws IOException{
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		PaymentOrder paymentOrder = paymentOrderDao.get(orderId);
		JSONObject jo = new JSONObject();
		if(paymentOrder==null){
			jo.put("rc", -1);
			jo.put("msg", "订单已失效");
			ServletUtils.writeResponse(response, new RESTResponse("data",jo));
		}
		if("1".equals(paymentOrder.getPaymentState())){//未缴费未删除
			schoolsPaymentService.updateOrderWay(orderId,paymentWay);
			jo.put("id", orderId);
			jo.put("rc", 0);
			ServletUtils.writeResponse(response, new RESTResponse("data",jo));
		}else if("2".equals(paymentOrder.getPaymentState())){
			jo.put("rc", -1);
			jo.put("msg", "订单已支付");
			ServletUtils.writeResponse(response, new RESTResponse("data",jo));
		}
	}
	
	
	/**
	 * 美容证书缴费
	 */
	@RequestMapping(value="qualificationCertificate")
	public String QualificationCertificatePay(String id,Model model, RedirectAttributes redirectAttributes){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		GroomerQualificationCertificate certificate = groomerQualificationCertificateService.get(id);
		List<PaymentOrderDetail> list = schoolsPaymentService.certificateToOrder(certificate);
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder paymentOrder = paymentOrderDao.getOrderByRunningNum(orderCode);
		model.addAttribute("order", list) ;
		model.addAttribute("ti", trainingInstitutionDao.get(ti.getId()));
		model.addAttribute("redUrl", "redirect:/schools/schoolsGroomerQualificationCertificate/list?repage");
		model.addAttribute("orderId", paymentOrder.getId());
		return "schools/pay/paymentPage";
	}
}
