package com.cku.restful.v1.sys.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.restful.v1.dog.model.RestDogBirthCertificate;

import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;

public class BeanUtil<T> {

	public static void main(String[] args) {
		DogBirthCertificate a1 = new DogBirthCertificate();
		a1.setDogBirthday(new Date());
		a1.setSnCode("222222222");
		RestDogBirthCertificate a2 = new RestDogBirthCertificate();
		BeanUtil.copyProperties(a2, a1, "yyyy-MM-dd");
		System.out.println(a1);
		System.out.println(a2.getDogBirthday());
	}

	public static void copyProperties(Object dest, Object orig,
			String datePattern) {
		ConvertUtils.register(new Converter() {
			@Override
			public Object convert(Class type, Object value) {
				if (value == null) {
					return null;
				}
				if (value instanceof Date) {
					SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
					String str = sdf.format((Date) value);
					return str;
				}
				return value;
			}
		}, String.class);
		try {
			BeanUtils.copyProperties(dest, orig);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	public static <T> T toBean(String json, Class type) {
		JSONObject jsonObject = JSONObject.fromObject(json);
		String[] dateFormats = new String[] { "yyyy-MM-dd" };
		JSONUtils.getMorpherRegistry().registerMorpher(
				new DateMorpher(dateFormats));
		return (T) JSONObject.toBean(jsonObject, type);
	}
	
	public static <T> T toBean(String json, Class type,Map<String,Class<?>> classMap) {
		JSONObject jsonObject = JSONObject.fromObject(json);
		String[] dateFormats = new String[] { "yyyy-MM-dd" };
		JSONUtils.getMorpherRegistry().registerMorpher(
				new DateMorpher(dateFormats));
		return (T) JSONObject.toBean(jsonObject, type,classMap);
	}
	
	public static <T> List<T> toList(String json, Class<T> type) {
		List<T> list = new ArrayList<T>();
		JSONArray jan = JSONArray.fromObject(json);
		String[] dateFormats = new String[] { "yyyy-MM-dd" };
		JSONUtils.getMorpherRegistry().registerMorpher(
				new DateMorpher(dateFormats));
		for (int i = 0; i < jan.size(); i++) {
			JSONObject jo = jan.getJSONObject(i);
			T t = (T) JSONObject.toBean(jo, type);
			list.add(t);
		}
		return list;
	}

	/**
	 * 合并两个对象的属性，以 source 对象的非空属性为准
	 *
	 * @param target 目标对象
	 * @param source 源对象
	 */
	public static void merge(Object target, Object source) {
		if (target == null || source == null) {
			throw new IllegalArgumentException("Target and source objects cannot be null");
		}

		if (!target.getClass().equals(source.getClass())) {
			throw new IllegalArgumentException("Target and source objects must be of the same class");
		}

		try {
			Field[] fields = target.getClass().getDeclaredFields();
			for (Field field : fields) {
				field.setAccessible(true);
				if (field.getName().equals("serialVersionUID")) {
					continue;
				}
				Object sourceValue = field.get(source);
				if (sourceValue != null && (sourceValue instanceof String ? !((String) sourceValue).isEmpty() : true)) {
					field.set(target, sourceValue);
				}
			}
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}



}