package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.oa.nativedog.dao.NativeDogInfoDao;
import com.cku.oa.nativedog.dao.NativeDogNewsDao;
import com.cku.oa.nativedog.entity.NativeDogInfo;
import com.cku.oa.nativedog.entity.NativeDogNews;
import com.cku.restful.v1.sys.model.RestNativeDogInfo;
import com.cku.restful.v1.sys.model.RestNativeDogNews;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by lyyz on 2018/12/11.
 */
@Controller
@RequestMapping(value = "/api/v1/open/nativedog")
public class OpenCKUNativeDogController  extends BaseRestController {
    @Autowired
    private NativeDogInfoDao nativeDogInfoDao;

    @Autowired
    private NativeDogNewsDao nativeDogNewsDao;

    @RequestMapping(value = "/info/list", method = RequestMethod.GET)
    @ResponseBody
    public void nativeDogInfoList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        List<HashMap<String,Object>> list = nativeDogInfoDao.getNativeDogInfoList();
        RESTResponse result = new RESTResponse("data",list);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/info/detail", method = RequestMethod.GET)
    @ResponseBody
    public void nativeDogInfoDetail(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        String id = request.getParameter("id");
        NativeDogInfo nativeDogInfo = nativeDogInfoDao.get(id);
        RestNativeDogInfo restNativeDogInfo = new RestNativeDogInfo();
        BeanUtils.copyProperties(nativeDogInfo,restNativeDogInfo);
        RESTResponse result = new RESTResponse("data",restNativeDogInfo);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/news/list", method = RequestMethod.GET)
    @ResponseBody
    public void nativeDogNewsList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        List<HashMap<String,Object>> list = nativeDogNewsDao.getNativeDogNewsList();
        RESTResponse result = new RESTResponse("data",list);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/news/detail", method = RequestMethod.GET)
    @ResponseBody
    public void nativeDogNewsDetail(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        String id = request.getParameter("id");
        NativeDogNews nativeDogNews = nativeDogNewsDao.get(id);
        RestNativeDogNews restNativeDogNews = new RestNativeDogNews();
        BeanUtils.copyProperties(nativeDogNews,restNativeDogNews);
        RESTResponse result = new RESTResponse("data",restNativeDogNews);
        ServletUtils.writeResponse(response, result);
    }

}
