package com.cku.restful.v1.groomer.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.groomer.model.RestGroomerQualificationCertificate;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 *user chaixueteng
 *2016年9月21日
 */
@Service
@Transactional(readOnly = true)
public class RestGroomerQualificationCertifiCateService {
	
	@Autowired
	public GroomerQualificationCertificateService groomerQualificationCertificateService;
	
	/**
	 * 领取胸花
	 * @Author chaixueteng
	 * @2016年9月21日下午8:15:23
	 */
	@Transactional(readOnly = false)
	public RESTResponse reveiveCorsage(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		if(!MemberUtil.isActiveMember(member)){
		    throw new ZAException(ZAErrorCode.ZA_ERROR,"会员无效！");
		}
		if (StringUtils.isBlank(member.getGroomerType())||member.getGroomerEndDate()==null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,
					"您不是美容师会员!");
		}
		GroomerQualificationCertificate gqc = groomerQualificationCertificateService.getLevel(member.getMemberCode());
		if (gqc!=null) {
			String corsage = gqc.getCorsage();
			if ("1".equals(corsage)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR,
						"您已经领取过胸花了!");
			}else{
				String levelEn = gqc.getLevelEn();
				if ("A".equals(levelEn)||"MASTER".equals(levelEn)) {
					GroomerQualificationCertificate certificate = groomerQualificationCertificateService.get(gqc.getId());
					certificate.setCorsage("1");
					certificate.setCorsageTime(new Date());
					groomerQualificationCertificateService.updateCorsage(certificate);
				}else{
					throw new ZAException(ZAErrorCode.ZA_ERROR,
							"您不符合领取条件!");
				}
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"您不符合领取条件!");
		}
		return new RESTResponse();
	}

	/**
	 * 返回会员信息
	 * @Author chaixueteng
	 * @2016年9月21日下午8:19:59
	 */
	public RESTResponse memberMsg(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		RestGroomerQualificationCertificate rgqc = new RestGroomerQualificationCertificate();
		rgqc.setMemberCode(member.getMemberCode());
		rgqc.setName(member.getName());
		GroomerQualificationCertificate gqc = groomerQualificationCertificateService.getLevel(member.getMemberCode());
		if (gqc!=null) {
			rgqc.setCertificateCode(gqc.getCertificateCode());
			rgqc.setLevelCn(gqc.getLevelCn());
		}
		return new RESTResponse("data",JSONObject.fromObject(rgqc));
	}
	
	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private MemberService memberService;
	/**
	 * 
	 * @description: CKU官网美容资格证书查询
	 * @author: laiguanglong
	 * @date: 2016年9月27日 下午7:58:29
	 */
	public RESTResponse getByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "key为空");
		}
		GroomerQualificationCertificate groomerQualificationCertificate = new GroomerQualificationCertificate();
		List<GroomerQualificationCertificate> po = groomerQualificationCertificateDao.getByKey(key);
		RestGroomerQualificationCertificate vo = null;
		if (po.size()>0) {
			vo = new RestGroomerQualificationCertificate();
			GroomerQualificationCertificate gqc = po.get(0);
			if ("MASTER".equals(gqc.getLevelEn().trim())) {//如果是教师资格证书
				groomerQualificationCertificate = gqc;
			}else{//不存在教师级证书 返回最大的级别
				groomerQualificationCertificate=po.get(po.size()-1);
			}
			BeanUtil.copyProperties(vo, groomerQualificationCertificate, "yyyy-MM-dd");
		}
		/*if (groomerQualificationCertificate != null) {
			Member member = memberService.getByMemberCode(groomerQualificationCertificate.getMemberCode());
			if(StringUtils.isBlank(member.getGroomerType())||member.getGroomerEndDate()==null||new Date().after(member.getGroomerEndDate())){
				groomerQualificationCertificate.setMemberCode("会员信息无效");
			}
		}*/
		return new RESTResponse("data", vo);
	}
	
	/**
	 * 
	 * @description: CKU官网美容胸花申领查询
	 * @author: xinhongwei
	 * @throws IOException 
	 * @date: 2017年2月7日 下午4:00:40
	 */
	public RESTResponse getCorsageClaimList() {
		List<String> corsageClaimList = groomerQualificationCertificateDao.getCorsageClaimList();
		return new RESTResponse("data",corsageClaimList); 
	}
	
}