package com.cku.restful.v1.groomer.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.GroomerCourseApplicationDao;
import com.cku.oa.groomer.dao.GroomerCourseDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.restful.v1.groomer.model.AppGroomerCourse;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.schools.mrschool.service.OSSUtils;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 美容师活动Service
 *
 * @author cxt
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class AppGroomerCourseService {
	@Autowired
	private GroomerCourseDao groomerCourseDao;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;
	@Autowired
	private GroomerCourseApplicationDao groomerCourseApplicationDao;
	@Autowired
	private MemberDao memberDao;

	public RESTResponse getCourseList(HttpServletRequest request) {
		String key = request.getParameter("key");
		String type = request.getParameter("type");
		String diplomaLevel = request.getParameter("diplomaLevel");
		String pageSize = request.getParameter("pageSize");
		String pageNo = request.getParameter("pageNo");
		Integer pageSizeInt = null;
		Integer pageNoInt = null;
		if (StringUtils.isNotBlank(pageSize)) {
			try {
				pageSizeInt = Integer.valueOf(pageSize);
				pageNoInt = ( Integer.valueOf(pageNo) - 1) * pageSizeInt ;
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"pageSize必须为整数");
			}
		}
		List<GroomerCourse> courseList = new ArrayList<>();
		if("0".equals(key) || StringUtils.isBlank(key)){
			 courseList = groomerCourseDao.getGroomerCourseList("",type,diplomaLevel);
		}else if("1".equals(key)){
			courseList = groomerCourseDao.getCourseList("price","ASC",type,diplomaLevel);
		}else if("2".equals(key)){
			courseList = groomerCourseDao.getCourseList("price","DESC",type,diplomaLevel);
		}else if("3".equals(key)){
			courseList = groomerCourseDao.getCourseList("launch_time","DESC",type,diplomaLevel);
		}else if("4".equals(key)){
//			最多参与
			courseList = groomerCourseDao.getGroomerCourseList("4",type,diplomaLevel);
		}else if("5".equals(key)){
//			为你推荐
			courseList = groomerCourseDao.getGroomerCourseList("5",type,diplomaLevel);
		}
		long count = courseList.size();
		if(pageNoInt<courseList.size()){
			if((pageNoInt+pageSizeInt) < courseList.size()){
				courseList = courseList.subList(pageNoInt,(pageNoInt+pageSizeInt));
			}else{
				courseList = courseList.subList(pageNoInt,courseList.size());
			}
		}
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image2/" ;
		List<AppGroomerCourse>  resultList = courseList.stream().map(data->{
			AppGroomerCourse vo = new AppGroomerCourse();
			BeanUtil.copyProperties(vo, data, "MM/dd");
			TrainingInstitution trainingInstitution = trainingInstitutionDao.get(data.getSchoolId());
			vo.setSchoolName(trainingInstitution.getSchoolNameCn());
			vo.setSchoolAddress(trainingInstitution.getAddress());
			vo.setTypeName(DictUtils.getDictLabel(data.getType(), "course_type", ""));
			vo.setCover(data.getCover() == null ? "" : (imgPath+data.getCover()));
			vo.setProvince(trainingInstitution.getProvince());
			vo.setCity(trainingInstitution.getCity());
			vo.setCity(trainingInstitution.getCity());
			if(vo.getRegistrationEndTime() != null && vo.getRegistrationEndTime().getTime() < new Date().getTime()){
				vo.setFlag(false);
			}else{
				vo.setFlag(true);
			}
			if("1".equals(vo.getType())){
				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
				vo.setTrainingTime(getString(sdf.format(vo.getStartDate()))+"-"+getString(sdf.format(vo.getEndDate())));
				vo.setRegistrationTime(getString(sdf.format(vo.getRegistrationStarteTime()))+"-"+getString(sdf.format(vo.getRegistrationEndTime())));
			}
			if(StringUtils.isNotBlank(vo.getVideo())){
				vo.setVideo(OSSUtils.getVodUrl(vo.getVideo()));
			}
			int num = groomerCourseApplicationDao.countByCourseId(data.getId());
			vo.setApplyNum(num+"");
			return vo;
		}).collect(Collectors.toList());
		return new RESTResponse("data", resultList);
	}
	public RESTResponse getCourseDetail(HttpServletRequest request) {
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image2/" ;

		String id = request.getParameter("id");
		HashMap<String ,Object> map =new HashMap<String ,Object>();
		GroomerCourse course = groomerCourseDao.get(id);
		map.put("courseName",course.getCourseName());
		map.put("courseDetails", updateTable(StringEscapeUtils.unescapeHtml4(course.getCourseDetails())));
		map.put("video",course.getVideo() == null ? "" : OSSUtils.getVodUrl(course.getVideo()));
		map.put("typeName",DictUtils.getDictLabel(course.getType(), "course_type", ""));
		map.put("cover",(course.getCover() == null ? "" : (imgPath+course.getCover())));
		map.put("type",course.getType());
		map.put("diplomaLevel",course.getDiplomaLevel());
		String schoolId = course.getSchoolId();
		TrainingInstitution trainingInstitution = trainingInstitutionDao.get(schoolId);
		map.put("schoolNameCn",trainingInstitution.getSchoolNameCn());
		map.put("schoolAvatar",trainingInstitution.getAvatar() == null ? "" : (imgPath+trainingInstitution.getAvatar()));
		map.put("schoolIntroduce",StringEscapeUtils.unescapeHtml4(trainingInstitution.getIntroduce()));
		map.put("qualifications",trainingInstitution.getQualifications());
		String teacherId = course.getTeacherId();
		if(StringUtils.isNotBlank(teacherId)){
			TeacherLecturer teacherLecturer = schoolsTeacherDao.get(teacherId);
			map.put("teacherName",course.getTeacher());
			map.put("teacherAvatar",teacherLecturer.getAvatar() == null ? "" :(imgPath+teacherLecturer.getAvatar()));
			map.put("teacherIntroduce",StringEscapeUtils.unescapeHtml4(teacherLecturer.getIntroduce()));
		}else{
			map.put("teacherName","");
			map.put("teacherAvatar","");
			map.put("teacherIntroduce","");
		}
		Member loginMember = UserUtils.getLoginMember();
		GroomerCourseApplication application = groomerCourseApplicationDao.getOneByMemberCodeACourseId(loginMember.getMemberCode(),id);
		if(application != null){
			map.put("application",true);
		}else{
			map.put("application",false);

		}

		return new RESTResponse("data", map);
	}

	public RESTResponse getMyCourseList(HttpServletRequest request) {
		String pageSize = request.getParameter("pageSize");
		String pageNo = request.getParameter("pageNo");
		Integer pageSizeInt = null;
		Integer pageNoInt = null;
		if (StringUtils.isNotBlank(pageSize)) {
			try {
				pageSizeInt = Integer.valueOf(pageSize);
				pageNoInt = ( Integer.valueOf(pageNo) - 1) * pageSizeInt ;
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"pageSize必须为整数");
			}
		}
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image2/" ;
		List<AppGroomerCourse>  resultList = new ArrayList<>();
		Member loginMember = UserUtils.getLoginMember();
		List<GroomerCourseApplication> list = groomerCourseApplicationDao.findByMemberCode(loginMember.getMemberCode());
		if(!Collections3.isEmpty(list)){
			List<GroomerCourseApplication> result = list.stream().filter(a ->
					"2".equals(a.getPaymentState()) || StringUtils.isBlank(a.getPaymentState())
			).collect(Collectors.toList());
			List<String> idList  = result.stream().map(data->{
				return  data.getCourseId();
			}).collect(Collectors.toList());

			List<GroomerCourse> courseList = groomerCourseDao.getByIds(idList);
			if(pageNoInt<courseList.size()){
				if((pageNoInt+pageSizeInt) < courseList.size()){
					courseList = courseList.subList(pageNoInt,(pageNoInt+pageSizeInt));
				}else{
					courseList = courseList.subList(pageNoInt,courseList.size());
				}
			}
			resultList = courseList.stream().map(data->{
				AppGroomerCourse vo = new AppGroomerCourse();
				BeanUtil.copyProperties(vo, data, "MM/dd");
				TrainingInstitution trainingInstitution = trainingInstitutionDao.get(data.getSchoolId());
				vo.setSchoolId(trainingInstitution.getSchoolNameCn());
				vo.setSchoolAddress(trainingInstitution.getAddress());
				vo.setTypeName(DictUtils.getDictLabel(data.getType(), "course_type", ""));
				vo.setCover(data.getCover() == null ? "" : (imgPath+data.getCover()));
				if(StringUtils.isNotBlank(vo.getVideo())){
					vo.setVideo(OSSUtils.getVodUrl(vo.getVideo()));
				}
				if(vo.getRegistrationEndTime() != null && vo.getRegistrationEndTime().getTime() < new Date().getTime()){
					vo.setFlag(false);
				}else{
					vo.setFlag(true);
				}
				GroomerCourseApplication application = groomerCourseApplicationDao.getOneByMemberCodeACourseId(loginMember.getMemberCode(),vo.getId());
				if(application != null){
					vo.setApplication(true);
				}else{
					vo.setApplication(false);
				}
				return vo;
			}).collect(Collectors.toList());
		}
		return new RESTResponse("data", resultList);
	}
	private static String getString(String str){
		return str==null?"":str;
	}
	private static String updateTable(String str){
        String result = "";
        if(StringUtils.isNotBlank(str) && str.contains("<table")){
            result = str.replace("<table","<table border = \"1\"");
        }
		return result;
	}

	public RESTResponse getOneCourseDetail(HttpServletRequest request) {
		String path = request.getContextPath();
		String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image2/" ;
		String id = request.getParameter("id");
		HashMap<String ,Object> map =new HashMap<String ,Object>();
		GroomerCourse course = groomerCourseDao.get(id);
		map.put("courseName",course.getCourseName());
		map.put("code",course.getCode());
		map.put("typeName",DictUtils.getDictLabel(course.getType(), "course_type", "无"));
		map.put("type",course.getType());
		map.put("price",course.getPrice());
		map.put("diplomaLevel",course.getDiplomaLevel());
		map.put("teacherName",course.getTeacher());
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		map.put("startDate",getString(sdf.format(course.getStartDate())));
		map.put("endDate",getString(sdf.format(course.getEndDate())));
		String schoolId = course.getSchoolId();
		TrainingInstitution trainingInstitution = trainingInstitutionDao.get(schoolId);
		map.put("schoolNameCn",trainingInstitution.getSchoolNameCn());
		Member loginMember = UserUtils.getLoginMember();
		map.put("memberCode",loginMember.getMemberCode());
		map.put("memberCardType",DictUtils.getDictLabel(loginMember.getMemberCardType(), "member_card_type", "无"));
		map.put("groomerType",DictUtils.getDictLabel(loginMember.getGroomerType(), "user_groomer_type", "无"));
		map.put("memberAvatar",loginMember.getAvatar() == null ? "" : (imgPath+loginMember.getAvatar()));
		GroomerCourseApplication courseApplication = groomerCourseApplicationDao.getOneByMemberCodeACourseId(loginMember.getMemberCode(), id);
		map.put("registrationTime",courseApplication.getCreateDate() == null ? "" :getString(sdf.format(courseApplication.getCreateDate())));
		return new RESTResponse("data", map);
	}

	@Transactional(readOnly = false)
	public RESTResponse study(String json) {
		JSONObject object = JSONObject.fromObject(json);
		String id = object.getString("id");
		GroomerCourse groomerCourse = groomerCourseDao.get(id);
		Member member = UserUtils.getLoginMember();
		GroomerCourseApplication g = groomerCourseApplicationDao.getOneByMemberCodeACourseId(member.getMemberCode(),groomerCourse.getId());
		if(g == null){
			GroomerCourseApplication po = new GroomerCourseApplication();
			po.setCourseCode(groomerCourse.getCode());
			po.setCourseId(groomerCourse.getId());
			po.setCoursePrice(groomerCourse.getPrice());
			po.setMemberCode(member.getMemberCode());
			po.setName(member.getName());
			po.setMobile(member.getMobile());
			po.setProvince(member.getProvince());
			po.setCity(member.getCity());
			po.setArea(member.getArea());
			po.setStreet(member.getStreet());
			po.setAddress(member.getAddress());
			po.preInsert();
			groomerCourseApplicationDao.insert(po);
		}
		return new RESTResponse();
	}
	@Transactional(readOnly = false)
	public RESTResponse play(String json) {
		JSONObject object = JSONObject.fromObject(json);
		String id = object.getString("id");
		GroomerCourse groomerCourse = groomerCourseDao.get(id);
		String playTimes = groomerCourse.getPlayTimes() == null ? "0" : groomerCourse.getPlayTimes();
		int i = Integer.parseInt(playTimes) + 1;
		groomerCourse.setPlayTimes(i+"");
		groomerCourse.preUpdate();
		groomerCourseDao.update(groomerCourse);
		return new RESTResponse();
	}
}