package com.cku.restful.v1.gcWeb.web;

import com.cku.core.ListResultDto;
import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.restful.v1.gcWeb.service.RestGCWebService;
import com.cku.restful.v1.gcWeb.vo.*;
import com.cku.restful.v1.sys.web.BaseRestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "美容官网")
@RestController
@RequestMapping(value = "/api/v1/open/gc")
public class OpenGCWebController extends BaseRestController {

	@Autowired
	private RestGCWebService restGCWebService;


	@ApiOperation(value = "轮播图列表查询")
	@GetMapping(value = "/banner")
	@ResponseBody
	public ListResultDto<GCWebBannerResponse> findBanner() {
		return restGCWebService.findBanner();
	}

	@ApiOperation(value = "分页列表查询")
	@GetMapping(value = "/page")
	@ResponseBody
	public PageResultDto<GCWebPageResponse> findPage(GCWebPageRequest request) {
		return restGCWebService.findPage(request);
	}

	@ApiOperation(value = "根据ID查询详情")
	@GetMapping(value = "/detail")
	@ResponseBody
	public ResultDto<GCWebDetailResponse> findDetail(GCWebDetailRequest request) {
		return restGCWebService.findDetail(request);
	}

	@ApiOperation(value = "底部信息查询")
	@GetMapping(value = "/footer")
	@ResponseBody
	public ResultDto<GCWebFooterResponse> findFooter() {
		return restGCWebService.findFooter();
	}

}
