/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dogNoseprin.entity;

import java.math.BigDecimal;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 奖池设置表Entity
 * 
 * @author xx
 * @version 2020-05-07
 */
public class DogPrizePool extends DataEntity<DogPrizePool> {

	private static final long serialVersionUID = 1L;
	private String poolCode; // 分组编号
	private String prizeCode; // 奖品编号
	private String prizeName; // 奖品名称
	private Integer totalNum; // 奖品总个数
	private Integer num; // 已发出个数
	private BigDecimal facePrice; // 面值

	public DogPrizePool() {
		super();
	}

	public DogPrizePool(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "分组编号长度必须介于 1 和 60 之间")
	public String getPoolCode() {
		return poolCode;
	}

	public void setPoolCode(String poolCode) {
		this.poolCode = poolCode;
	}

	@Length(min = 1, max = 60, message = "奖品编号长度必须介于 1 和 60 之间")
	public String getPrizeCode() {
		return prizeCode;
	}

	public void setPrizeCode(String prizeCode) {
		this.prizeCode = prizeCode;
	}

	@Length(min = 1, max = 100, message = "奖品名称长度必须介于 1 和 100 之间")
	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public Integer getTotalNum() {
		return totalNum;
	}

	public void setTotalNum(Integer totalNum) {
		this.totalNum = totalNum;
	}

	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	public BigDecimal getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(BigDecimal facePrice) {
		this.facePrice = facePrice;
	}

}