package com.cku.restful.v1.dogNose.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.ResultDto;
import com.cku.restful.v1.dogNose.model.RestDogNoseCheckinRequest;
import com.cku.restful.v1.dogNose.model.RestDogNoseCheckinResponse;
import com.cku.restful.v1.dogNose.model.RestDogNoseNotifyRequest;
import com.cku.restful.v1.dogNose.model.RestDogNoseNotifyResponse;
import com.cku.restful.v1.dogNose.service.RestDogNoseCheckinService;
import com.cku.restful.v1.sys.web.BaseRestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 犬只鼻纹信息管理Controller
 * 
 */
@RestController
@RequestMapping(value = "/api/v1/dog/nose")
@Api(tags = "鼻纹识别登记接口-ZJW")
public class RestDogNoseCheckinController extends BaseRestController {

	@Autowired
	private RestDogNoseCheckinService restDogNoseCheckinService;
	
	@ApiOperation(value = "鼻纹识别登记")
	@PostMapping(value = "/checkin")
	public ResultDto<RestDogNoseCheckinResponse> noseCheckin(@RequestBody RestDogNoseCheckinRequest request,HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
		return restDogNoseCheckinService.noseCheckin(request);
	}
	
	@ApiOperation(value = "鼻纹识别通知")
	@PostMapping(value = "/notify")
	public ResultDto<RestDogNoseNotifyResponse> noseNotify(@RequestBody RestDogNoseNotifyRequest request,HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
		return restDogNoseCheckinService.noseNotify(request);
	}

}