package com.cku.restful.v1.dog.web;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.BasePageRequest;
import com.cku.core.PageResultDto;
import com.cku.core.QueryByIdRequest;
import com.cku.core.ResultDto;
import com.cku.restful.v1.dog.service.RestGoldCertifiedAuditService;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedApplyAuditRequest;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedAuditDetailResp;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedAuditPageResp;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.thinkgem.jeesite.common.persistence.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Controller
@RequestMapping(value = "/api/v1/goldCertifiedAudit")
@Api(tags = "金质证书父母犬审核接口")
public class RestGoldCertifiedAuditController extends BaseRestController {

	@Autowired
	RestGoldCertifiedAuditService service;

	@ApiOperation(value = "列表")
	@GetMapping(value = "/list")
	@ResponseBody
	public PageResultDto<GoldCertifiedAuditPageResp> findPage(@Valid BasePageRequest request) {
		Page<GoldCertifiedAuditPageResp> respPage = service.findPage(request);
		return PageResultDto.success(respPage.getList(), respPage.getCount());
	}
	
	

	@ApiOperation(value = "详情")
	@GetMapping(value = "detail")
	@ResponseBody
	public ResultDto<GoldCertifiedAuditDetailResp> detail(@Valid QueryByIdRequest request) {
		GoldCertifiedAuditDetailResp resp = service.detail(request.getId());
		return ResultDto.success(resp);
	}
	
	@ApiOperation(value = "发送验证码")
	@PostMapping(value = "/sendVerifyCode")
	@ResponseBody
	public ResultDto<Boolean> sendVerifyCode(HttpServletRequest request){
		return ResultDto.success(service.sendVerifyCode(request));
	}

	@ApiOperation(value = "审批")
	@PostMapping(value = "/audit")
	@ResponseBody
	public ResultDto<Boolean> audit(@RequestBody @Valid GoldCertifiedApplyAuditRequest request) throws Exception {
		return ResultDto.success(service.audit(request));
	}
	


}
