package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogStickerApplyService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/api/v1/dog/dogStickerApply")
public class RestDogStickerApplyController extends BaseRestController {

    @Autowired
    private RestDogStickerApplyService service;

    @RequestMapping(value = "/getById/{id}", method = RequestMethod.GET)
    public void get(@PathVariable("id") String id, HttpServletResponse response)
            throws IOException {
        RESTResponse result = service.get(id);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "", method = RequestMethod.GET)
    public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = service.getList(request);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/checkByKey", method = RequestMethod.GET)
    public void checkByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = service.checkByKey(request);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "", method = RequestMethod.POST)
    public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
        RESTResponse result = service.post(json);
        ServletUtils.writeResponse(response, result);
    }
}
