/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 犬只信息管理Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v1/dog")
public class CkuDogBirthCertificateController extends BaseRestController {

	@Autowired
	private RestDogBirthCertificateService birthCertificateService;

	/**
	 * CKU官网 出生纸查询是否有宠爱登记卡号
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/birthcertificate/checkSnCode", method = RequestMethod.GET)
	@ResponseBody
	public void checkSnCodeByIdentificationFlag(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ServletUtils.writeResponse(response, birthCertificateService.checkSnCodeByIdentificationFlag(request));
	}

	/**
	 * @description: CKU官网，出生纸查询接口
	 * @author: laiguanglong
	 * @date: 2017/6/28 11:07
	 */
	@RequestMapping(value = "/birthcertificate", method = RequestMethod.GET)
	@ResponseBody
	public void getBySnCodeOrIdentificationFlag(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ServletUtils.writeResponse(response, birthCertificateService.getBySnCodeOrIdentificationFlag(request));
	}

	/**
	 * @description: CKU官网，出生纸查询接口 旧
	 * @author: laiguanglong
	 * @date: 2017/6/28 11:07
	 */
	@RequestMapping(value = "/birthcertificate/old", method = RequestMethod.GET)
	@ResponseBody
	public void getBySnCodeOrIdentificationFlagOld(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ServletUtils.writeResponse(response, birthCertificateService.getBySnCodeOrIdentificationFlagOld(request));
	}

	/**
	 * @description: 出生纸二维码查询接口
	 * @author: laiguanglong
	 * @date: 2017/6/28 11:07
	 */
	@RequestMapping(value = "/birthcertificate/getByIdentificationFlag", method = RequestMethod.GET)
	@ResponseBody
	public void getByIdentificationFlag(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, birthCertificateService.getByIdentificationFlag(request));
	}

	/**
	 * @description: 出生纸验证
	 * @author: zhangxiang
	 * @date: 2020/6/28 11:07
	 */
	@RequestMapping(value = "/birthcertificate/getByIdentificationFlagValidate", method = RequestMethod.GET)
	@ResponseBody
	public void getByIdentificationFlagValidate(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ServletUtils.writeResponse(response, birthCertificateService.getByIdentificationFlagValidate(request));
	}

}