package com.cku.restful.v1.ckudc.service;


import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.restful.v1.dog.model.RestDog;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.model.RestKennel;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.JSONUtils;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by user on 2016/12/10.
 */
@Service
@Transactional(readOnly = true)
public class RestCkudcService {

    @Autowired
    private RestDogService restDogService;
    @Autowired
    public DogService dogService;
    @Autowired
    public DogTypeService dogTypeService;
    @Autowired
    private KennelDao kennelDao;
    @Autowired
    private DogNewbornService dogNewbornService;
    /**
     *
     * @description:  CKUDC查询犬只信息接口
     * @author: lyy
     */
    public RESTResponse getDogInfo(HttpServletRequest request) {
        // 获取参数
        String key = request.getParameter("key");
        //type 类型
        // birthCertificateLevelCode;		// 出生证明登记编号
        // pedigreeCertifiedCode;		    // 血统证书号
        // identificationFlag;		        // 身份识别标记
        String type = request.getParameter("type");
        // 参数校验
        if (StringUtils.isBlank(key)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
        }
        if (StringUtils.isBlank(type)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
        }
        // 查询犬信息
        Dog dog = null;
        if("birthCertificateLevelCode".equals(type)){
            dog = dogService.getByBirthCertificateLevelCode(key);
        }else if("pedigreeCertifiedCode".equals(type)){
            dog = dogService.getByPedigreeCertifiedCode(key);
        }else if("identificationFlag".equals(type)){
            dog = dogService.getByIdentificationFlag(key);
        }
        if (dog == null || "1".equals(dog.getDelFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数有误，没有响应查询结果！");
        }
        RestDog vo = new RestDog();
        BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
        if (StringUtils.isNotBlank(vo.getDogBreed())) {
            DogType dogType = dogTypeService
                    .getByDogBreedCode(vo.getDogBreed());
            if(dogType==null){
                vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
                vo.setDogBreedNameEn("");
            }else{
                vo.setDogBreedName(dogType.getBreedCnName());
                vo.setDogBreedNameEn(dogType.getBreedEnName());
            }
        }
        vo.setGender(DictUtils.getDictLabel(vo.getGender(), "dog_gender", ""));
        return restDogService.dogInfo(vo, dog);
    }


    /**
     *
     * @description:  CKUDC查询犬舍信息接口
     * @author: lyy
     */
    public RESTResponse getKennel(HttpServletRequest request){
        String name = request.getParameter("name");
        if(com.thinkgem.jeesite.common.utils.StringUtils.isBlank(name)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬舍名为空");
        }
        Kennel kennel = kennelDao.getByName(name);
        RestKennel vo = null;
        if(kennel!=null){
            vo = new RestKennel();
            BeanUtil.copyProperties(vo, kennel, "yyyy-MM-dd");
            String type = "";
            if("year".equals(vo.getType())){
                type = "年度";
            }else if("permanent".equals(vo.getType())){
                type = "永久";
            }
            vo.setType(type);
        }
        return new RESTResponse("data",vo);
    }
    /**
     *
     * @description:CKUDC犬只交配查询接口
     * @author: lyy
     */
    public RESTResponse bloodline(HttpServletRequest request) {
        // 获取参数
        String fatherPedigreeCertified = request.getParameter("fatherPedigreeCertified");
        String motherPedigreeCertified = request.getParameter("motherPedigreeCertified");
        if (StringUtils.isBlank(fatherPedigreeCertified)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号为空");
        }
        if (StringUtils.isBlank(motherPedigreeCertified)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号为空");
        }
        return new RESTResponse("data", restDogService.bloodline(fatherPedigreeCertified,motherPedigreeCertified));
    }

    /**
     *
     * @description:CKUDC种犬配犬信息查询接口
     * @author: lyy
     */
    public RESTResponse getDogNewBornByMale(HttpServletRequest request) {
        // 获取参数  公犬证书号
        String malePedigreeCertified = request.getParameter("malePedigreeCertified");
        if (StringUtils.isBlank(malePedigreeCertified)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "公犬血统证书号为空");
        }
        DogNewborn dogNewborn = new DogNewborn();
        dogNewborn.setMalePedigreeCertified(malePedigreeCertified);
        List<DogNewborn>  list =  dogNewbornService.findList(dogNewborn);
        JSONObject jo = new JSONObject();
        jo.put("data", JSONUtils.convertObject(convertNewBorn(list)));
        return new RESTResponse(jo);
    }
    private List convertNewBorn(List<DogNewborn> list){
        List<HashMap<String,String>> r = new ArrayList<HashMap<String,String>>();
        for(DogNewborn d:list){
            HashMap<String,String> m = new HashMap<String,String>();
            m.put("maleDogOwner",d.getMaleDogName());
            m.put("mdogOwnerCode",d.getMdogOwnerCode());
            m.put("femaleDogOwner",d.getFemaleDogOwner());
            m.put("fdogOwnerCode",d.getFdogOwnerCode());
            m.put("maleDogName",d.getMaleDogName());
            m.put("malePedigreeCertified",d.getMalePedigreeCertified());
            m.put("femaleDogName",d.getFemaleDogName());
            m.put("femalePedigreeCertified",d.getFemalePedigreeCertified());
            m.put("breedDate", DateUtils.formatDate(d.getBreedDate()));
            r.add(m);
        }
        return r;
    };
}
