/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.DogType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @description: 犬种
 * @author: laiguanglong
 * @date: 2017/10/16 10:25
 */
@Service
@Transactional(readOnly = true)
public class RestDogBreedService {

    @Autowired
    private DogTypeDao dogTypeDao;
    @Autowired
    private StudDogService studDogService;

    public RESTResponse hotDogBreed() {
        List<JSONObject> list = Lists.newArrayList();
        List<Dict> dictList = DictUtils.getDictList("hot_dog_breed");
        for (Dict dict : dictList) {
            JSONObject jo = new JSONObject();
            jo.put("breedCnName", dict.getLabel());
            jo.put("dogBreed", dict.getValue());
            list.add(jo);
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

    public RESTResponse dogBreed(HttpServletRequest request) {
        List<String> dogBreedList = studDogService.getDogBreedList();
        Map map = Maps.newHashMap();
        map.put("key", request.getParameter("key"));
        map.put("dogBreedList", dogBreedList);
        List<DogType> dogTypeList = dogTypeDao.getInDogBreedList(map);
        List<JSONObject> list = Lists.newArrayList();
        for (DogType dogType : dogTypeList) {
            JSONObject jo = new JSONObject();
            jo.put("breedCnName", dogType.getBreedCnName());
            jo.put("dogBreed", dogType.getDogBreedCode());
            list.add(jo);
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

}