/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.partner.club.dao;

import com.cku.partner.club.entity.CompanionDogAppraisal;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 伴侣级鉴定DAO接口
 *
 * @author pp
 * @version 2019-07-04
 */
@MyBatisDao
public interface CompanionDogAppraisalDao extends CrudDao<CompanionDogAppraisal> {

    CompanionDogAppraisal getByIdentificationFlag(@Param("identificationFlag") String identificationFlag, @Param("petType") String petType);

    List<Map<String, String>>  getCatByIdentificationFlag(String identificationFlag);
    List<Map<String, String>>  getCatBirthCertificateByIdentificationFlag(String identificationFlag);

    /**
     * 根据护照号查询
     *
     * @param passportNo
     * @return
     */
    CompanionDogAppraisal getByCabPassport(@Param("passportNo") String passportNo);

    Long customSql(@Param("sql") String sql);
}