package com.cku.oa.timedtask.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sync.dao.ActivitySyncLogDao;
import com.cku.oa.sync.dao.SaisiPeixunMeirongDao;
import com.cku.oa.sync.entity.ActivitySyncLog;
import com.cku.oa.sync.entity.SaisiPeixunMeirong;
import com.ufida.api.response.UfidaSyncResponse;
import com.ufida.api.service.UfidaBaseInfoSyncService;
import com.ufida.api.vo.FitemVo;

@Service
@Transactional(readOnly = true)
public class UfidaFitemSyncTask extends JobActingService    {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private SaisiPeixunMeirongDao saisiPeixunMeirongDao;
	
	@Autowired
	private ActivitySyncLogDao activitySyncLogDao;

	@Autowired
	private UfidaBaseInfoSyncService ufidaBaseInfoSyncService;

	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			List<SaisiPeixunMeirong> selectSaisi = saisiPeixunMeirongDao.selectSaisi();
			for (SaisiPeixunMeirong temp : selectSaisi) {
				UfidaSyncResponse syncProject = ufidaBaseInfoSyncService.syncProject(
						new FitemVo(temp.getType(), temp.getShowCode(), temp.getShowName(), temp.getStartTime(), temp.getEndTime()));
				activitySyncLogDao.insert(new ActivitySyncLog(temp.getType(), temp.getId(), temp.getShowCode(), temp.getShowName(),
						temp.getStartTime(), temp.getEndTime(), syncProject.success()));
			}
			count = selectSaisi.size();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

	@Override
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			count = this.doJob();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

	 

}