package com.cku.oa.timedtask.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sys.service.user.MemberService;

@Service
@Transactional(readOnly = true)
public class MemberCardTypeReviseTask extends JobActingService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private MemberService memberService;

	@Transactional(readOnly = false)
	int doJob() {
		return reviseMemberCardType();
	}

	@Override
	@Transactional(readOnly = false)
	public int executeOnce() {
		SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
		return reviseMemberCardType();
	}

	private int reviseMemberCardType() {
		int row = 0;
		try {
			row = memberService.reviseMemberCardType();
		} catch (Exception ex) {
			ex.printStackTrace();
			row = -1;
		} finally {
			logger.info("修改数据,执行条数：" + row);
		}
		return row;
	}

}