package com.cku.oa.sys.zalog;


import com.cku.core.ZAException;
import com.cku.oa.sys.code.SysCodeUtil;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/6
 * Time: 15:03
 */
public class SysContext implements SysState {
    public static SysZaLogDao zaLogDao;
    private SysState sysState;
    private SysNowState nowState;
    private SysZaLog sysZaLog = new SysZaLog();
    public SysContext(){};

    /**
     * 构造方法
     * @param paymentState
     * @param reviewState
     * @param proccessState
     */
    public SysContext(String paymentState, String reviewState, String proccessState){
        sysZaLog.setId(IdGen.uuid());
        sysZaLog.setPayoutState(paymentState);
        sysZaLog.setReviewState(reviewState);
        sysZaLog.setProcessState(proccessState);
        sysZaLog.setAddTime(new Date());
        //sysZaLog.setOperator();
        sysZaLog.setCensor(UserUtils.getUser().getNo());
        if("0".equals(paymentState) && "0".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.NoOrder;
            sysState = new SysNoOrderState();
        }if("1".equals(paymentState) && "0".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.NoPayout;
            sysState = new SysNoPayoutState();
        }else if("3".equals(paymentState) && "0".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.TimeOutPay;
            sysState = new SysTimeOutPayState();
        }else if("2".equals(paymentState) && "0".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.FinishPayout;
            sysState = new SysFinishPayoutState();
        }else if("2".equals(paymentState) && "1".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.SuccessConfirm;
            sysState = new SysSuccessConfirmState();
        }else if("2".equals(paymentState) && "2".equals(reviewState) && "0".equals(proccessState)){
            nowState = SysNowState.FailConfirm;
            sysState = new SysFailConfirmState();
        }else if("2".equals(paymentState) && "1".equals(reviewState) && "1".equals(proccessState)){
            nowState = SysNowState.End;
            sysState = new SysEndState();
        }else{
            nowState = SysNowState.No;
            sysState = new SysNoState();
        }
        sysZaLog.setNowState(nowState.toString());
    }
    /*
       静态代码块，植入dao
     */
    static{
        zaLogDao = SysCodeUtil.getBean("sysZaLogDao");
    }

    public SysState getSysState() {
        return sysState;
    }

    public void setSysState(SysState sysState) {
        this.sysState = sysState;
    }

    public SysNowState getNowState() {
        return nowState;
    }

    public void setNowState(SysNowState nowState) {
        this.nowState = nowState;
    }

    public SysZaLog getSysZaLog() {
        return sysZaLog;
    }

    public void setSysZaLog(SysZaLog sysZaLog) {
        this.sysZaLog = sysZaLog;
    }

    /**
     * 生成订单方法
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void createOrder(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.payment(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }
    /**
     * 支付方法
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void payment(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.payment(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 取消支付方法
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void cancelApply(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.cancelApply(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 审核通过
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void confirmSuccess(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.confirmSuccess(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 审核不通过
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void confirmFail(SysContext ckuContext, String info,String errorInfo,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.confirmFail(ckuContext,info,errorInfo,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 修改信息
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void updateInfo(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.updateInfo(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 变更数据
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void updateData(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.updateData(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }

    /**
     * 线下退款
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void offlineRefund(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException {
        this.sysState.offlineRefund(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }
    /**
     * 状态机以外的状态，不由状态机控制，只负责入库
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    @Override
    public void noStateExecute(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException{
        this.sysState.noStateExecute(ckuContext,info,memberCode,tableName,businessId,runningNumber,consumer);
    }
}
