package com.cku.oa.sys.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;

public class DateUtils {

	public static void main(String[] args) throws ParseException {
//		System.out.println(String.format("该域名%s被访问了 %s 次.", "111", "22222"));

		Date d1 = sdf.parse("2020-07-01");
		System.out.println(isInXMounth(d1, 3));
	}

	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	/**
	 * 
	 * @description: 传入的时间是否在当前时间x个月内 1要求传入的日期都是yyyy-MM-dd的格式，时分秒都得是0 2x必须为大于0的正整数
	 *               3假设传入的参数为2016-11-14 00：00：00，只要当前时间小于2016-12-14 23：59：59都返回true
	 * @author: laiguanglong
	 * @date: 2016年12月14日 下午6:05:38
	 */
	public static boolean isInXMounth(Date date, int x) {
		if (date == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "日期为空");
		}
		if (x < 1) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "月份数必须为大于1的正整数");
		}
		try {
			date = sdf.parse(sdf.format(date));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "日期有误");
		}
		Calendar dateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		dateCalendar.add(Calendar.MONTH, x); // 月份加x
		dateCalendar.add(Calendar.DATE, 1); // 日期加1
		if (System.currentTimeMillis() < dateCalendar.getTimeInMillis()) {
			return true;
		} else {
			return false;
		}
	}

	public static String dateToStr(Date dateDate) {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String dateString = formatter.format(dateDate);
		return dateString;
	}

	/**
	 * 获取日期差值，获取两个日期的相差月份
	 * 
	 * @param date1
	 * @param date2
	 * @param x
	 * @return
	 */
	public static boolean isInXMounth(Date date1, Date date2, int x) {
		if (date1 == null || date2 == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "日期为空");
		}
		if (x < 1) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "月份数必须为大于1的正整数");
		}
		try {
			date1 = sdf.parse(sdf.format(date1));
			date2 = sdf.parse(sdf.format(date2));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "日期有误");
		}
		Calendar startDateCalendar = Calendar.getInstance();
		Calendar endDateCalendar = Calendar.getInstance();
		if (date1.before(date2)) {
			startDateCalendar.setTime(date1);
			endDateCalendar.setTime(date2);
		} else {
			startDateCalendar.setTime(date2);
			endDateCalendar.setTime(date1);
		}

		int year = endDateCalendar.get(Calendar.YEAR) - startDateCalendar.get(Calendar.YEAR);
		int month = endDateCalendar.get(Calendar.MONTH) - startDateCalendar.get(Calendar.MONTH);
		if (year * 12 + month < x) {
			return true;
		} else if (year * 12 + month == x) {
			return endDateCalendar.get(Calendar.DAY_OF_MONTH) <= startDateCalendar.get(Calendar.DAY_OF_MONTH);
		} else {
			return false;
		}
	}

	public static boolean isInOneYearOld(Date date) {
		// 一岁到两岁之前的犬只申请时,DNA留存方式默认为位点分析（不能修改）
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(Calendar.YEAR, 1);
		calendar.add(Calendar.DATE, 1);
		return calendar.getTimeInMillis() > System.currentTimeMillis();
	}

	public static String formatDateToStr(Date dateDate) {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String dateString = formatter.format(dateDate);
		return dateString;
	}

}