/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity.user;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 会员限制计数Entity
 * @author yuanshuai
 * @version 2017-12-21
 */
public class MemberLimitCount extends DataEntity<MemberLimitCount> {

	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private int checkIDCardLimit;		// 身份证后六位校验限制次数
	private int validateIDCardLimit;		// 身份证实名认证校验次数

	public MemberLimitCount() {
		super();
	}

	public MemberLimitCount(String id){
		super(id);
	}

	public MemberLimitCount(String memberCode, int checkIDCardLimit, int validateIDCardLimit) {
		this.memberCode = memberCode;
		this.checkIDCardLimit = checkIDCardLimit;
		this.validateIDCardLimit = validateIDCardLimit;
	}

	@Length(min=1, max=64, message="会员号长度必须介于 1 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min=0, max=11, message="身份证后六位校验限制次数长度必须介于 0 和 11 之间")
	public int getCheckIDCardLimit() {
		return checkIDCardLimit;
	}

	public void setCheckIDCardLimit(int checkIDCardLimit) {
		this.checkIDCardLimit = checkIDCardLimit;
	}

	@Length(min=0, max=11, message="身份证实名认证校验次数长度必须介于 0 和 11 之间")
	public int getValidateIDCardLimit() {
		return validateIDCardLimit;
	}

	public void setValidateIDCardLimit(int validateIDCardLimit) {
		this.validateIDCardLimit = validateIDCardLimit;
	}

}