/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.ExpressQueue;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 待邮寄物品DAO接口
 * 
 * @author fanhuibin
 * @version 2016-09-01
 */
@MyBatisDao
public interface ExpressQueueDao extends CrudDao<ExpressQueue> {

    
    List<ExpressQueue> getByIds(@Param("ids") List<String> ids);
	
	/**
	 * 逻辑删除待发货邮件记录
	 * 
	 * @param id
	 * @return
	 */
	Integer deleteByBusinessId(@Param("id") String id);

	/**
	 * 逻辑删除待发货邮件记录
	 * 
	 * @param id
	 * @return
	 */
	Integer deleteByBusinessIds(@Param("ids") Set<String> ids);

}