package com.cku.oa.statistics.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.oa.statistics.service.PaymentRecordDataAdjustmentService;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 收费项 数据调整
 */
@Controller
@RequestMapping(value = "/statistics/paymentRecord")
public class PaymentRecordDataAdjustmentController {

	@Autowired
	private PaymentRecordDataAdjustmentService paymentRecordDataAdjustmentService;

	@RequestMapping(value = "adjustment")
	@ResponseBody
	public Map<String, Object> adjustment(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> map = new HashMap<>();
		map.put("code", "0");
		map.put("message", "OK");
		String endDate = request.getParameter("endDate");
		String startDate = request.getParameter("startDate");
		if (StringUtils.isEmpty(startDate)) {
			map.put("code", "-1");
			map.put("message", "开始时间不能为空");
			return map;
		}
		if (StringUtils.isEmpty(endDate)) {
			map.put("code", "-1");
			map.put("message", "开始时间不能为空");
			return map;
		}
		paymentRecordDataAdjustmentService.adjustment(startDate, endDate);
		return map;
	}

}
