package com.cku.oa.statistics.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.util.DateUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.statistics.entity.MemberVip;
import com.cku.oa.statistics.service.MemberVipService;

import java.util.List;

/**
 * 大客户数据Controller
 *
 * @author yuanshuai
 * @version 2020-06-29
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/memberVip")
public class MemberVipController extends BaseController {

	@Autowired
	private MemberVipService memberVipService;

	@ModelAttribute
	public MemberVip get(@RequestParam(required = false) String id) {
		MemberVip entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = memberVipService.get(id);
		}
		if (entity == null) {
			entity = new MemberVip();
		}
		return entity;
	}

	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = {"list", ""})
	public String list(MemberVip memberVip, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<MemberVip> page = memberVipService.findPage(new Page<MemberVip>(request, response), memberVip);
		model.addAttribute("page", page);
		return "oa/statistics/memberVip/memberVipList";
	}

	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = "form")
	public String form(MemberVip memberVip, Model model) {
		model.addAttribute("memberVip", memberVip);
		return "oa/statistics/memberVip/memberVipForm";
	}

	@RequiresPermissions("statistics:memberVip:edit")
	@RequestMapping(value = "save")
	public String save(MemberVip memberVip, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, memberVip)) {
			return form(memberVip, model);
		}
		memberVipService.save(memberVip);
		addMessage(redirectAttributes, "保存大客户数据成功");
		return "redirect:" + Global.getAdminPath() + "/statistics/memberVip/?repage";
	}


	/**
	 * 大客户血统证书进度查询
	 *
	 * @author: yuanshuai
	 * @date: 2020/6/29 15:27
	 */
	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = {"scheduleStat"})
	public String scheduleStat(MemberVip memberVip, HttpServletRequest request, HttpServletResponse response, Model model) {
		List<MemberVip> memberVipList = memberVipService.findScheduleStat(memberVip);
		model.addAttribute("memberVipList", memberVipList);
		model.addAttribute("memberVip", memberVip);
		return "oa/statistics/memberVip/scheduleStatList";
	}

	/**
	 * @Description： 导出大客户血统证书进度
	 * @author: yuanshuai
	 * @date: 2020/6/30 11:00
	 */
	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = {"exportScheduleStat"})
	public void exportScheduleStat(MemberVip memberVip, HttpServletResponse response, RedirectAttributes redirectAttributes, Model model) {
		List<MemberVip> list;
		try {
			list = memberVipService.exportScheduleStat(memberVip);
			// 导出
			new ExportExcel("大客户血统证书", MemberVip.class, 2).setDataList(list).write(response, "大客户血统证书.xlsx").dispose();
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出赛事信息失败！失败信息：" + e.getMessage());
		}
	}

	/**
	 * @Description： 大客户数据导入
	 * @author: yuanshuai
	 * @date: 2020/6/30 11:26
	 */
	@RequiresPermissions("statistics:memberVip:edit")
	@RequestMapping(value = "import", method= RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			//大客户信息导入
			memberVipService.importMemberVip(file);
			addMessage(redirectAttributes, "导入大客户数据成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入大客户数据失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/statistics/memberVip/?repage";
	}

	/**
	 * 下载导入赛事信息模板
	 * @param response
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		List<MemberVip> list;
		try {
			list = memberVipService.importFileTemplate();
			new ExportExcel("大客户数据导入模板", MemberVip.class, 2).setDataList(list).write(response, "大客户数据导入模板.xlsx").dispose();
			return null;
		} catch (Exception e) {
			e.printStackTrace();
			addMessage(redirectAttributes, "导入模板下载失败！失败信息："+e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/statistics/memberVip/?repage";
		}
	}
}