package com.cku.oa.showRefereeDelegate.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.showRefereeDelegate.entity.ShowRefereeDelegateLog;
import com.cku.oa.showRefereeDelegate.service.ShowRefereeDelegateLogService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 犬展裁判委派记录Controller
 *
 * @author 袁帅
 * @version 2021-03-16
 */
@Controller
@RequestMapping(value = "${adminPath}/show/delegateLog")
public class ShowRefereeDelegateLogController extends BaseController {

	@Autowired
	private ShowRefereeDelegateLogService showRefereeDelegateLogService;

	@ModelAttribute
	public ShowRefereeDelegateLog get(@RequestParam(required = false) String id) {
		ShowRefereeDelegateLog entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = showRefereeDelegateLogService.get(id);
		}
		if (entity == null) {
			entity = new ShowRefereeDelegateLog();
		}
		return entity;
	}

	@RequiresPermissions("show:delegateLog:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowRefereeDelegateLog showRefereeDelegateLog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowRefereeDelegateLog> page = showRefereeDelegateLogService.findPage(new Page<ShowRefereeDelegateLog>(request, response), showRefereeDelegateLog);
		model.addAttribute("page", page);
		return "oa/showRefereeDelegate/showRefereeDelegateLogList";
	}

	@RequiresPermissions("show:delegateLog:view")
	@RequestMapping(value = "form")
	public String form(ShowRefereeDelegateLog showRefereeDelegateLog, Model model) {
		model.addAttribute("showRefereeDelegateLog", showRefereeDelegateLog);
		return "oa/showRefereeDelegate/showRefereeDelegateLogForm";
	}

	@RequiresPermissions("show:delegateLog:edit")
	@RequestMapping(value = "save")
	public String save(ShowRefereeDelegateLog showRefereeDelegateLog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showRefereeDelegateLog)) {
			return form(showRefereeDelegateLog, model);
		}
		showRefereeDelegateLogService.save(showRefereeDelegateLog);
		addMessage(redirectAttributes, "保存犬展委派记录成功");
		return "redirect:" + Global.getAdminPath() + "/show/delegateLog/?repage";
	}

	@RequiresPermissions("show:delegateLog:del")
	@RequestMapping(value = "delete")
	public String delete(ShowRefereeDelegateLog showRefereeDelegateLog, RedirectAttributes redirectAttributes) {
		showRefereeDelegateLogService.delete(showRefereeDelegateLog);
		addMessage(redirectAttributes, "删除犬展委派记录成功");
		return "redirect:" + Global.getAdminPath() + "/show/delegateLog/?repage";
	}


	/**
	 * 导入模板
	 * @author yuanshuai
	 * @date 2021/3/17 10:19
	 */
	@RequiresPermissions("show:delegateLog:import")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			showRefereeDelegateLogService.importFileTemplate(response);
			return null;
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/show/delegateLog/?repage";
	}

	/**
	 * 导入委派记录
	 * @author yuanshuai
	 * @date 2021/3/17 10:19
	 */
	@RequiresPermissions("show:delegateLog:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, Model model, RedirectAttributes redirectAttributes) {
		try {
			showRefereeDelegateLogService.importShowReferee(file);
			addMessage(redirectAttributes,"导入犬展委派记录成功。");
		} catch (Exception e) {
			addMessage(redirectAttributes,"导入犬展委派记录失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/show/delegateLog/?repage";
	}
}