package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowHotel;
import com.cku.oa.show.service.ShowHotelService;

/**
 * 犬展酒店Controller
 * @author cxt
 * @version 2017-08-02
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showHotel")
public class ShowHotelController extends BaseController {

	@Autowired
	private ShowHotelService showHotelService;
	private final static String URL_PRDFIX = "oa/show/hotel/";

	@ModelAttribute
	public ShowHotel get(@RequestParam(required=false) String id) {
		ShowHotel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showHotelService.get(id);
		}
		if (entity == null){
			entity = new ShowHotel();
		}
		return entity;
	}
	
	@RequiresPermissions("show:showHotel:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowHotel showHotel, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowHotel> page = showHotelService.findPage(new Page<ShowHotel>(request, response), showHotel); 
		model.addAttribute("page", page);
		return URL_PRDFIX+"showHotelList";
	}

	@RequiresPermissions("show:showHotel:view")
	@RequestMapping(value = "view")
	public String view(ShowHotel showHotel, Model model) {
		model.addAttribute("showHotel", showHotel);
		return URL_PRDFIX+"showHotelView";
	}
	
	@RequiresPermissions("show:showHotel:edit")
	@RequestMapping(value = "form")
	public String form(ShowHotel showHotel, Model model) {
		model.addAttribute("showHotel", showHotel);
		return URL_PRDFIX+"showHotelForm";
	}

	@RequiresPermissions("show:showHotel:edit")
	@RequestMapping(value = "save")
	public String save(ShowHotel showHotel, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(StringUtils.isEmpty(showHotel.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("show:showHotel:add");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("show:showHotel:edit");
		}
		if(!hasPermission){
			throw new AuthorizationException("用户权限不足");
		}
		
		if (!beanValidator(model, showHotel)){
			return form(showHotel, model);
		}
		showHotelService.save(showHotel);
		addMessage(redirectAttributes, "保存犬展酒店成功");
		return "redirect:"+Global.getAdminPath()+"/show/showHotel/?repage";
	}
	
	@RequiresPermissions("show:showHotel:delete")
	@RequestMapping(value = "delete")
	public String delete(ShowHotel showHotel, RedirectAttributes redirectAttributes) {
		showHotelService.delete(showHotel);
		addMessage(redirectAttributes, "删除犬展酒店成功");
		return "redirect:"+Global.getAdminPath()+"/show/showHotel/?repage";
	}

}