package com.cku.oa.show.service;

import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.entity.*;
import com.cku.oa.show.vo.ShowReportInfoRequest;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.dao.ShowReportInfoDao;
import org.springframework.util.CollectionUtils;

/**
 * 犬展播报信息Service
 * @author lyy
 * @version 2018-01-22
 */
@Service
@Transactional(readOnly = true)
public class ShowReportInfoService extends CrudService<ShowReportInfoDao, ShowReportInfo> {
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ShowJudgeService showJudgeService;
	@Autowired
	private ShowResultsService showResultsService;

	public ShowReportInfo get(String id) {
		return super.get(id);
	}
	
	public List<ShowReportInfo> findList(ShowReportInfo showReportInfo) {
		return super.findList(showReportInfo);
	}
	
	public Page<ShowReportInfo> findPage(Page<ShowReportInfo> page, ShowReportInfo showReportInfo) {
		return super.findPage(page, showReportInfo);
	}
	public List<ShowJudge> findJudgeByMainShowId(String mainShowId){
		List<ShowJudge> result = new ArrayList<>();
		MainShows mainShows = mainShowsService.get(mainShowId);
		String referees = mainShows.getReferee();
		if(StringUtils.isNotBlank(referees)){
			String [] arr = referees.split(",");
			for(String judgeId : arr){
				ShowJudge pre = showJudgeService.get(judgeId);
				result.add(pre);
			}
		}
		return result;
	}
	public ShowJudge findJudgeNameById(String id){
		return showJudgeService.get(id);
	}
	@Transactional(readOnly = false)
	public void save(ShowReportInfo showReportInfo) {
		if(StringUtils.isBlank(showReportInfo.getId())){
			showReportInfo.setLookCount(0);
		}
		//处理裁判信息
		int judgePicCount = (int) Stream.of(showReportInfo.getJudgePic(), showReportInfo.getJudgePic2(), showReportInfo.getJudgePic3())
				.filter(s -> !StringUtils.isBlank(s))
				.count();
		int judgeCount = (int) Stream.of(showReportInfo.getJudgeId(), showReportInfo.getJudgeId2(), showReportInfo.getJudgeId3())
				.filter(s -> !StringUtils.isBlank(s))
				.count();
		if (judgePicCount > judgeCount) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "裁判照片数量不可大于裁判数量。");
		}
		String judgePics = Stream.of(showReportInfo.getJudgePic(), showReportInfo.getJudgePic2(), showReportInfo.getJudgePic3())
				.filter(s -> !StringUtils.isBlank(s))
				.collect(Collectors.joining(","));
		showReportInfo.setJudgePic(judgePics);
		String judgeIds = Stream.of(showReportInfo.getJudgeId(), showReportInfo.getJudgeId2(), showReportInfo.getJudgeId3())
				.filter(s -> !StringUtils.isBlank(s))
				.collect(Collectors.joining(","));
		showReportInfo.setJudgeId(judgeIds);
		super.save(showReportInfo);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowReportInfo showReportInfo) {
		super.delete(showReportInfo);
	}

	/**
	 * 根据犬展编号查询成绩信息
	 * @author yuanshuai
	 * @date 2021/5/27 10:16
	 */
	public ShowReportInfoRequest findAllScoreByShowCode(String showCode) {
		ShowReportInfoRequest showReportInfoRequest = new ShowReportInfoRequest();
		List<ShowResults> resultsList = showResultsService.findAllBISByShowCode(showCode);
		if (CollectionUtils.isEmpty(resultsList)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "请先上传本场犬展成绩。");
		}
		resultsList.forEach(showResults -> {
			switch (showResults.getResultBis()) {
				case "BIS1":
					showReportInfoRequest.setBIS1(showResults);
					break;
				case "BIS2":
					showReportInfoRequest.setBIS2(showResults);
					break;
				case "BIS3":
					showReportInfoRequest.setBIS3(showResults);
					break;
				case "BIS4":
					showReportInfoRequest.setBIS4(showResults);
					break;
				case "JBIS1":
					showReportInfoRequest.setJBIS1(showResults);
					break;
				case "JBIS2":
					showReportInfoRequest.setJBIS2(showResults);
					break;
				case "JBIS3":
					showReportInfoRequest.setJBIS3(showResults);
					break;
				case "JBIS4":
					showReportInfoRequest.setJBIS4(showResults);
					break;
				case "PBIS1":
					showReportInfoRequest.setPBIS1(showResults);
					break;
				case "PBIS2":
					showReportInfoRequest.setPBIS2(showResults);
					break;
				case "PBIS3":
					showReportInfoRequest.setPBIS3(showResults);
					break;
				case "PBIS4":
					showReportInfoRequest.setPBIS4(showResults);
					break;
				case "BPBIS1":
					showReportInfoRequest.setBBIS1(showResults);
					break;
				case "BPBIS2":
					showReportInfoRequest.setBBIS2(showResults);
					break;
				case "BPBIS3":
					showReportInfoRequest.setBBIS3(showResults);
					break;
				case "BPBIS4":
					showReportInfoRequest.setBBIS4(showResults);
					break;
				default:
			}
		});
		return showReportInfoRequest;
	}

}