/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 犬种组赛事裁判证书表Entity
 *
 * @author lgl
 * @version 2018-09-20
 */
public class ShowJudgeCertificateDogGroup extends DataEntity<ShowJudgeCertificateDogGroup> {

    private static final long serialVersionUID = 1L;
    private String judgeCertificateMian;        // 主裁判证书号
    private String judgeCertificate;        // 裁判证书号
    private Date signDate;        // 签发日期
    private Date endDate;        // 结束日期
    private String groupNo;        // 组别编号
    private String visibleFlag;        // 是否可见。0不可见；1可见

    public ShowJudgeCertificateDogGroup() {
        super();
    }

    public ShowJudgeCertificateDogGroup(String id) {
        super(id);
    }

    @Length(min = 1, max = 20, message = "主裁判证书号长度必须介于 1 和 20 之间")
    public String getJudgeCertificateMian() {
        return judgeCertificateMian;
    }

    public void setJudgeCertificateMian(String judgeCertificateMian) {
        this.judgeCertificateMian = judgeCertificateMian;
    }

    @Length(min = 1, max = 20, message = "裁判证书号长度必须介于 1 和 20 之间")
    public String getJudgeCertificate() {
        return judgeCertificate;
    }

    public void setJudgeCertificate(String judgeCertificate) {
        this.judgeCertificate = judgeCertificate;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "签发日期不能为空")
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "结束日期不能为空")
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Length(min = 1, max = 2, message = "组别编号长度必须介于 1 和 2 之间")
    public String getGroupNo() {
        return groupNo;
    }

    public void setGroupNo(String groupNo) {
        this.groupNo = groupNo;
    }

    @Length(min = 1, max = 1, message = "是否可见。0不可见；1可见长度必须介于 1 和 1 之间")
    public String getVisibleFlag() {
        return visibleFlag;
    }

    public void setVisibleFlag(String visibleFlag) {
        this.visibleFlag = visibleFlag;
    }

}