package com.cku.oa.shop.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.shop.entity.*;
import com.cku.oa.shop.service.*;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.util.JSONUtils;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 商城订单Controller
 * @author lyy
 * @version 2016-08-12
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopOrder")
public class ShopOrderController extends BaseController {

	@Autowired
	private ShopOrderService shopOrderService;
	@Autowired
	private ShopGoodsService shopGoodsService;
	@Autowired
	private ShopCartsService shopCartsService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private ShopUserAddressService shopUserAddressService;
	@Autowired
	private ShopUserMoneyService shopUserMoneyService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private ShopSaleChannelService shopSaleChannelService;
	
	@ModelAttribute
	public ShopOrder get(@RequestParam(required=false) String id) {
		ShopOrder entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopOrderService.get(id);
		}
		if (entity == null){
			entity = new ShopOrder();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopOrder:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopOrder shopOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShopOrder> page = shopOrderService.findPage(new Page<ShopOrder>(request, response), shopOrder); 
		model.addAttribute("page", page);
		return "oa/shop/shopOrderList";
	}

	@RequiresPermissions("shop:shopOrder:view")
	@RequestMapping(value = "form")
	public String form(ShopOrder shopOrder, Model model) {
		model.addAttribute("shopOrder", shopOrder);
		//商品下拉框
		ShopGoods selShopGoods = new ShopGoods();
		selShopGoods.setIsShelves("1");
		List<ShopGoods> goodsItems =shopGoodsService.findList(selShopGoods);
		model.addAttribute("goodsItems", goodsItems);
		String memberCode = shopOrder.getMemberCode();
		//购物车临时数据
		List<ShopCarts> cartsList = null;
		if(memberCode!=null && !"".equals(memberCode)){
			cartsList = shopCartsService.findListByMemberCode(memberCode);
		}
		model.addAttribute("cartsList",cartsList);
		//判断是不是合作机构
		Org org = orgService.getByMemberCode(memberCode);
		ShopUserMoney shopUserMoney =null;
		if(org==null){
			model.addAttribute("isOrg",0);
		}else{
			model.addAttribute("isOrg",1);
			//查询合作机构钱
			shopUserMoney = shopUserMoneyService.getByMemberCode(memberCode);
			if(shopUserMoney==null){
				shopUserMoney = new ShopUserMoney(memberCode,"0","0");
			}
		}
		model.addAttribute("shopUserMoney",shopUserMoney);
		//会员信息
		Member member = memberService.getByMemberCode(memberCode);
		model.addAttribute("member",member);

		//会员用户地址
		List<ShopUserAddress> shopUserAddressList = new ArrayList<ShopUserAddress>();
		shopUserAddressList = shopUserAddressService.findListByMemberCode(memberCode);
		//没有商城地址表数据的用户将会员表的注册地址添加到地址表中
		if(member!=null && (shopUserAddressList.size()==0)){
			ShopUserAddress shopUserAddress = new ShopUserAddress();
			shopUserAddress.setMemberCode(member.getMemberCode());
			shopUserAddress.setProvince(member.getProvince());
			shopUserAddress.setCity(member.getCity());
			shopUserAddress.setAddress(member.getStreet());
			shopUserAddress.setPostCode(member.getPostcode());
			shopUserAddress.setPostDel(member.getMobile());
			shopUserAddress.setPostName(member.getName());
			shopUserAddress.setIsDefault("1");
			shopUserAddressService.noAddressAddMemberAddress(shopUserAddress);
			shopUserAddressList.add(shopUserAddress);
		}
		model.addAttribute("shopUserAddressList",shopUserAddressList);
		//渠道
		List<ShopSaleChannel> channelList = shopSaleChannelService.findList(new ShopSaleChannel());
		model.addAttribute("channelList",channelList);
		//省市
		List<Area> provinceList = UserUtils.getProvince();
		model.addAttribute("provinceList",provinceList);
		List<Area> cityList = UserUtils.getCity();
		model.addAttribute("cityList",cityList);
		return "oa/shop/shopOrderForm";
	}
	@RequiresPermissions("shop:shopOrder:view")
	@RequestMapping(value = "view")
	public String view(ShopOrder shopOrder,Model model){
		model.addAttribute("shopOrder",shopOrder);
		return "oa/shop/shopOrderView";
	}

	@RequiresPermissions("shop:shopOrder:add")
	@RequestMapping(value = "save")
	public String save(ShopOrder shopOrder, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, shopOrder)){
			return form(shopOrder, model);
		}
		shopOrderService.save(shopOrder);
		addMessage(redirectAttributes, "保存创建者成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/?repage";
	}

	/**
	 * 选择邮寄类型得到邮费钱数
	 * @param shopOrder
	 * @param redirectAttributes
     * @return
     */
	@RequiresPermissions("shop:shopOrder:view")
	@RequestMapping("getPostPrice")
	@ResponseBody
	public String getPostPrice(ShopOrder shopOrder, RedirectAttributes redirectAttributes){
		String postPrice = shopOrderService.getPostPrice(shopOrder);
		return postPrice;
	}

	/**
	 * 选择买赠商品得到可赠送商品列表
	 * @param goodsId
	 * @param redirectAttributes
     * @return
     */
	@RequiresPermissions("shop:shopOrder:view")
	@RequestMapping("getLessGoodsList")
	@ResponseBody
	public String getLessGoodsList(String goodsId, RedirectAttributes redirectAttributes){
		List<HashMap<String,String>> goodsList = shopOrderService.getLessGoodsList(goodsId);
		return JSONUtils.toJSON(goodsList);
	}
	/**
	 * 跳转到退回页面
	 * @param shopOrder
	 * @return
	 */
	@RequiresPermissions("shop:shopOrder:returnGoods")
	@RequestMapping(value = "toReturnGoods")
	public String toReturnGoods(ShopOrder shopOrder,  Model model) {
		model.addAttribute("shopOrder",shopOrder);
		return "oa/shop/returnGoodsView";
	}

	/**
	 * 退回商品
	 * @param shopOrder
	 * @param model
     * @return
     */
	@RequiresPermissions("shop:shopOrder:returnGoods")
	@RequestMapping(value = "returnGoods")
	@ResponseBody
	public void returnGoods(ShopOrder shopOrder,  Model model) {
		shopOrderService.returnGoods(shopOrder);
	}
	/**
	 * 撤销订单
	 * @param shopOrder
	 * @param redirectAttributes
     * @return
     */
	@RequiresPermissions("shop:shopOrder:delete")
	@RequestMapping(value = "delOrder")
	public String delOrder(ShopOrder shopOrder, RedirectAttributes redirectAttributes) {
		shopOrderService.delOrder(shopOrder);
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/?repage";
	}
	/**
	 * 跳转到发送页面
	 * @param shopOrder
	 * @return
	 */
	@RequiresPermissions("shop:shopOrder:send")
	@RequestMapping(value = "toSendOrder")
	public String toSendOrder(ShopOrder shopOrder, Model model) {
		model.addAttribute("shopOrder",shopOrder);
		return "oa/shop/sendOrderView";
	}
	/**
	 * 发送订单
	 * @param shopOrder
     * @return
     */
	@RequiresPermissions("shop:shopOrder:send")
	@RequestMapping(value = "sendOrder")
	@ResponseBody
	public void sendOrder(ShopOrder shopOrder) {
		shopOrderService.sendOrder(shopOrder);
	}
}