/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.shop.entity.ShopUserMoney;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * 商城用户钱DAO接口
 * @author lyy
 * @version 2016-08-23
 */
@MyBatisDao
public interface ShopUserMoneyDao extends CrudDao<ShopUserMoney> {
	ShopUserMoney getByMemberCode(@Param("memberCode") String memberCode);
    /**
     *	会员扣费
     * @param memberCode
     * @param changeVal
     * @return
     */
    int memberCharge(@Param("memberCode") String memberCode, @Param("changeVal") String changeVal,@Param("type")String type);

    /**
     * 会员充值
     * @param memberCode
     * @param changeVal
     * @return
     */
    int memberRecharge(@Param("memberCode") String memberCode, @Param("changeVal") String changeVal,@Param("paymentTime") Date paymentTime,@Param("type")String type);
}