package com.cku.oa.project.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import com.cku.oa.project.entity.Month;
import com.cku.oa.project.entity.Week;
import com.cku.oa.project.entity.Year;
import com.thinkgem.jeesite.common.utils.DateUtils;

public class WeekUtil {

	/**
	 * 获取某个日期处于全年第几周
	 * 
	 * @param date
	 * @return
	 */
	public static Integer getWeekOfYear(int year, Date date) {
		if (Objects.isNull(date)) {
			return null;
		}
		Calendar tl = Calendar.getInstance();
		tl.setTime(date);
		if (tl.get(Calendar.YEAR) < year) {
			return 0;
		} else if (tl.get(Calendar.YEAR) > year) {
			int offsetYear = tl.get(Calendar.YEAR) - year;
			int offsetWeek = 0;
			Calendar tc = Calendar.getInstance();
			tc.set(offsetYear, Calendar.DECEMBER, 31);
			for (int i = 1; i <= offsetYear; i++) {
				tc.add(Calendar.YEAR, i);
				offsetWeek += WeekUtil.getWeekOfYear(tc.getTime());
			}
			return getWeekOfYear(date) + offsetWeek;

		} else {
			return getWeekOfYear(date);
		}
	}

	public static Integer getWeekOfYear(Date date) {
		if (Objects.isNull(date)) {
			return null;
		}
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int week = calendar.get(Calendar.WEEK_OF_YEAR);
		int mouth = calendar.get(Calendar.MONTH);
		// JDK think 2015-12-31 as 2016 1th week
		// 如果月份是12月，且求出来的周数是第一周，说明该日期实质上是这一年的第53周，也是下一年的第一周
		if (mouth >= 11 && week <= 1) {
			week += 52;
		}
		return week;
	}

	public static Year getYearMonthWeek(Integer year) {
		Calendar c1 = Calendar.getInstance();
		c1.set(Calendar.YEAR, year);
		c1.set(Calendar.MONTH, Calendar.JANUARY);
		c1.set(Calendar.DAY_OF_YEAR, 1);
		int currentYear = c1.get(Calendar.YEAR);
		List<Month> monthList = new ArrayList<>();
		for (int i = 1; i <= 12; i++) {
			monthList.add(Month.builder().month(i).weekList(new LinkedHashSet<>()).build());
		}
		while (true) {
			Month month = monthList.stream().filter(m -> m.getMonth().equals(c1.get(Calendar.MONTH) + 1)).findAny()
					.get();
			if (month.getMonth() == 12) {
				System.out.println(
						month.getWeekList().stream().map(w -> w.getWeek().toString()).collect(Collectors.joining(",")));
			}
			month.getWeekList().add(Week.builder().week(getWeekOfYear(c1.getTime())).build());
			c1.add(Calendar.DAY_OF_YEAR, 1);
			int newYear = c1.get(Calendar.YEAR);
			if (newYear > currentYear) {
				break;
			}
		}

		return Year.builder().year(year).colColumn(monthList.stream().mapToInt(w -> w.getWeekList().size()).sum())
				.monthList(monthList).build();
	}

	public static void main(String[] args) {

//		Calendar cl = Calendar.getInstance();
//		System.out.println("today is a 当年第" + cl.get(Calendar.WEEK_OF_YEAR) + "周");
//		System.out.println("today is a 当月第" + cl.get(Calendar.DAY_OF_MONTH) + "天");
//		System.out.println("today is a 当月第" + cl.get(Calendar.WEEK_OF_MONTH) + "周");
//
//		Calendar c = Calendar.getInstance();
//		c.set(Calendar.YEAR, 2021);
//		c.set(Calendar.MONTH, 11);
//		c.setFirstDayOfWeek(Calendar.MONDAY);
//		System.out.println(c.get(Calendar.YEAR) + "年" + (c.get(Calendar.MONTH) + 1) + "月");
//		System.out.println("天数：" + c.getActualMaximum(Calendar.WEEK_OF_YEAR));
//		System.out.println("Actual周数：" + c.getActualMaximum(Calendar.WEEK_OF_MONTH));
//		System.out.println("Max周数：" + c.getMaximum(Calendar.WEEK_OF_MONTH));

		Calendar c1 = Calendar.getInstance();
		c1.set(Calendar.YEAR, 2021);
		c1.set(Calendar.MONTH, Calendar.JANUARY);
		c1.set(Calendar.DAY_OF_YEAR, 1);
//		c1.setFirstDayOfWeek(Calendar.MONDAY);
		System.out.println(DateUtils.formatDate(c1.getTime(), "yyyy-MM-dd"));
		int currentYear = c1.get(Calendar.YEAR);
		Map<Integer, HashSet<Integer>> yearWeekMap = new HashMap<>();
		for (int i = 1; i <= 12; i++) {
			yearWeekMap.put(i, new HashSet<Integer>());
		}
		while (true) {
			yearWeekMap.get(c1.get(Calendar.MONTH) + 1).add(c1.get(Calendar.WEEK_OF_YEAR));
			c1.add(Calendar.DAY_OF_YEAR, 1);
			int newYear = c1.get(Calendar.YEAR);
			if (newYear > currentYear) {
				break;
			}
		}
		System.out.println("=============================================");
		yearWeekMap.keySet().stream().forEach(key -> {
			System.out.println("月份:" + key);
			yearWeekMap.get(key).stream().forEach(val -> {
				System.out.println("第" + val + "周");
			});
		});

	}
}
