package com.cku.oa.project.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.project.entity.CkuProject;
import com.cku.oa.project.dao.CkuProjectDao;

/**
 * 技术项目表Service
 * @author Sunny
 * @version 2021-12-07
 */
@Service
@Transactional(readOnly = true)
public class CkuProjectService extends CrudService<CkuProjectDao, CkuProject> {

	public CkuProject get(String id) {
		return super.get(id);
	}
	
	public List<CkuProject> findList(CkuProject ckuProject) {
		return super.findList(ckuProject);
	}
	
	public List<CkuProject> findListByYear(Integer year) {
		return dao.findListByYear(year);
	}
	
	public Page<CkuProject> findPage(Page<CkuProject> page, CkuProject ckuProject) {
		return super.findPage(page, ckuProject);
	}
	
	@Transactional(readOnly = false)
	public void save(CkuProject ckuProject) {
		super.save(ckuProject);
	}
	
	@Transactional(readOnly = false)
	public void delete(CkuProject ckuProject) {
		super.delete(ckuProject);
	}
	
}