package com.cku.oa.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

/**
 * @author yuanshuai
 * @date 2023/6/8 15:27
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class DnaParentsCompareBusinessVo extends OrderBusinessVo {

    private static final long serialVersionUID = -4459362489654240852L;

    @ApiModelProperty("犬只ID")
    private String dogId;

    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;

    @ApiModelProperty("出生纸编号")
    private String birthCode;

    @ApiModelProperty("申请来源（1:血统证书升级2:登记卡申请）")
    private Integer applySource;

    @ApiModelProperty(value = "DNA办理方式：0机构办理；1自检")
    private Integer dnaApplyChannel;

    @ApiModelProperty(value = "医院ID")
    private String hospitalId;
}
