package com.cku.oa.order.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.order.entity.BusinessOrder;
import com.cku.oa.order.dao.BusinessOrderDao;

/**
 * 业务订单Service
 * @author yuanshuai
 * @version 2023-06-20
 */
@Service
@Transactional(readOnly = true)
public class BusinessOrderService extends CrudService<BusinessOrderDao, BusinessOrder> {

	public BusinessOrder get(String id) {
		return super.get(id);
	}
	
	public List<BusinessOrder> findList(BusinessOrder businessOrder) {
		return super.findList(businessOrder);
	}
	
	public Page<BusinessOrder> findPage(Page<BusinessOrder> page, BusinessOrder businessOrder) {
		return super.findPage(page, businessOrder);
	}
	
	@Transactional(readOnly = false)
	public void save(BusinessOrder businessOrder) {
		super.save(businessOrder);
	}
	
	@Transactional(readOnly = false)
	public void delete(BusinessOrder businessOrder) {
		super.delete(businessOrder);
	}

	@Transactional(readOnly = false)
	public void deleteByOrderCode(String orderCode) {
		dao.deleteByOrderCode(orderCode);
	}
	
}