package com.cku.oa.kennel.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.dao.KennelRenameDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelRename;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.sys.zalog.SysNoState;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬舍名称变更Service
 * 
 * @author zhuguanjin
 * @version 2016-08-15
 */
@Service
@Transactional(readOnly = true)
public class KennelRenameService extends CrudService<KennelRenameDao, KennelRename> {

	private static final String KENNEL_RENAME = "犬舍名称变更";

	@Autowired
	private RemindService remindService;

	@Autowired
	private KennelService kennelService;
	@Autowired
	private KennelDao kennelDao;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private ExpressQueueService expressQueueService;
	
	public KennelRename get(String id) {
		return super.get(id);
	}

	public List<KennelRename> findList(KennelRename kennelRename) {
		return super.findList(kennelRename);
	}

	public Page<KennelRename> findPage(Page<KennelRename> page, KennelRename kennelRename) {
		return super.findPage(page, kennelRename);
	}

	@Transactional(readOnly = false)
	public void save(KennelRename kennelRename) {
		String newNameCn = kennelRename.getNewNameCn();
		if(StringUtils.isNotBlank(newNameCn) && !newNameCn.contains("犬舍")){
			kennelRename.setNewNameCn(newNameCn+"犬舍");
		}
		super.save(kennelRename);
		String date = new SimpleDateFormat("yyyy年MM月dd日HH时mm分").format(kennelRename.getCreateDate());
		String type = "";
		StringBuffer sb = new StringBuffer();
		sb.append("您于").append(date).append("提交了").append("犬舍名称变更申请，请您务必于当日24时前完成缴费，过期订单失效哦。");
		remindService.addRemind(sb.toString(), kennelRename.getMemberCode());
		System.out.println(sb);
	}

	@Transactional(readOnly = false)
	public void orderSave(KennelRename kennelRename) {
		if (StringUtils.isEmpty(kennelRename.getId())) {
			kennelRename.setKennelCode(kennelRename.getMemberCode());
		}
		Kennel kennel = kennelDao.getKennelByMemberCode(kennelRename.getMemberCode());
		// 【oa--订单--订单录入--犬舍名称变更】已有未处理的变更信息，应不可再次申请
		KennelRename example = new KennelRename();
		example.setMemberCode(kennelRename.getMemberCode());
		example.setProcessState("0");
		List<KennelRename> kennelRenameList = dao.findList(example);
		// 排除已撤销的记录
		for (Iterator<KennelRename> it = kennelRenameList.iterator(); it.hasNext();) {
			KennelRename item = it.next();
			if ("3".equals(item.getReviewState())) {
				it.remove();
			}
		}
		if (kennelRenameList.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员有未处理的犬舍名称变更记录");
		}
		kennel.setName(kennelRename.getNewNameCn());
		kennel.setNameEn(kennelRename.getNewNameEn());
		kennel.setFciName(kennelRename.getNewNameEn());
		kennel.setFciNameBackup(kennelRename.getFciKennelBackup());
		kennel.setPrintState("0");
		kennel.setFciPrintState("0");
		kennelRename.setKennel(kennel);
		// 根据支付项查询金额
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(kennelRename
				.getPaymentChargingItemId());
		kennelRename.setPaymentMoney(paymentChargingItem.getPrice());
		kennelRename.setReviewState("0");
		kennelRename.setPaymentState("2");
		kennelRename.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(kennelRename.getRunningNumber()));
		kennelRename.setProcessState("0");
		super.save(kennelRename);
	}

	@Transactional(readOnly = false)
	public void delete(KennelRename kennelRename) {
		super.delete(kennelRename);
	}

	@Transactional(readOnly = false)
	public void audit(KennelRename audit) throws Exception {
		try {
			KennelRename kennelRename = get(audit.getId());
			// 未通过的状态可以更改为任何状态，此处将未通过状态作为未审核进行处理 zhuoHeng
			if ("2".equals(kennelRename.getReviewState())) {
				kennelRename.setReviewState("0");
			}
			SysContext sysContext = new SysContext(kennelRename.getPaymentState(), kennelRename.getReviewState(),
					kennelRename.getProcessState());
			if ("1".equals(audit.getReviewState())) {
				kennelRename.setReviewState("1");
				sysContext.confirmSuccess(sysContext, KENNEL_RENAME + "审核", kennelRename.getMemberCode(),
						"kennel_rename", kennelRename.getId(), kennelRename.getRunningNumber(), (str) -> {
						});
			} else if ("2".equals(audit.getReviewState())) {
				kennelRename.setReviewState("2");
				sysContext.confirmFail(sysContext, KENNEL_RENAME + "审核", kennelRename.getReviewRemarks(),
						kennelRename.getMemberCode(), "kennel_rename", kennelRename.getId(),
						kennelRename.getRunningNumber(), (str) -> {
						});
				remindService.addRemind("您的犬舍名称变更审核未通过审核，请按照反馈意见修改再提交。", kennelRename.getMemberCode());
			} else if ("0".equals(audit.getReviewState()) || "3".equals(audit.getReviewState())) {
				kennelRename.setReviewState(audit.getReviewState()); // 未审核 注销 走无状态集 柴雪腾
				if ("3".equals(audit.getReviewState())) {
					String paymentState = kennelRename.getPaymentState();
					if ("1".equals(paymentState)) {
						throw new ZAException(ZAErrorCode.ZA_ERC_NO_STATE, "未支付状态，无法进行此操作！");
					}
				}
				new SysNoState().noStateExecute(sysContext, KENNEL_RENAME + "审核", kennelRename.getMemberCode(),
						"kennel_rename", kennelRename.getId(), kennelRename.getRunningNumber(), (str) -> {
						});
			}
			kennelRename.setReviewRemarks(audit.getReviewRemarks());
			kennelRename.setReviewTime(new Date());
			kennelRename.setNewNameCn(audit.getNewNameCn());
			kennelRename.setNewNameEn(audit.getNewNameEn());
			
			// 有申请铜牌添加到邮寄队列
			List<PaymentOrderDetail> details = paymentOrderDetailDao.findByOrderCode(kennelRename.getRunningNumber());
			if (details.stream()
					.filter((s) -> s.getChargingItemName().equals("永久犬舍铜牌补做费")).count() > 0) {
				expressQueueService.push(kennelRename.getMemberCode(), kennelRename.getRunningNumber(), "永久犬舍铜牌补", "", "kennel_rename",
						kennelRename.getId(), null);
			}
			super.save(kennelRename);
		} catch (Exception e) {
			throw e;
		}
	}

	@Transactional(readOnly = false)
	public void resolve(KennelRename review) throws Exception {
		try {
			KennelRename kennelRename = get(review.getId());
			/*
			 * String reviewState = kennelRename.getReviewState(); //由于犬只鉴定的审核状态与状态机的审核状态不一致，需要进行转换
			 * if("2".equals(reviewState)){ //审核中转换为未审核 reviewState = "0"; }else
			 * if("1".equals(reviewState)){ //通过 reviewState = "1"; }else{
			 * //其他包括0不通过，3非纯种犬，4注销都转换为未通过 reviewState = "2"; } SysContext sysContext = new
			 * SysContext(kennelRename
			 * .getPaymentState(),reviewState,kennelRename.getProcessState());
			 */
			SysContext sysContext = new SysContext(kennelRename.getPaymentState(), kennelRename.getReviewState(),
					kennelRename.getProcessState());
			sysContext.updateData(sysContext, KENNEL_RENAME + "处理", kennelRename.getMemberCode(), "kennel_rename",
					kennelRename.getId(), kennelRename.getRunningNumber(), (str) -> {
					});
			kennelRename.setProcessState("1");
			kennelRename.setProcessTime(new Date());
			super.save(kennelRename);
			remindService.addRemind("恭喜您的犬舍名称变更申请审核通过，新犬舍名为" + "\"" + kennelRename.getNewNameCn() + "\"。",
					kennelRename.getMemberCode());
			// 写入犬舍信息表 重置犬舍的打印状态
			insertKennel(kennelRename);
		} catch (Exception e) {
			throw e;
		}
	}

	@Transactional(readOnly = false)
	private String insertKennel(KennelRename kennelRename) {
		Kennel kennel = kennelService.get(kennelRename.getKennel().getId());
		kennel.setName(kennelRename.getNewNameCn());
		kennel.setNameEn(kennelRename.getNewNameEn());
		kennel.setFciName(kennelRename.getNewNameEn());
		kennel.setFciNameBackup(kennelRename.getFciKennelBackup());
		kennel.setReviewState("1");
		kennel.setFciReviewState("0");
		kennel.setPrintState("0");
		kennel.setFciPrintState("0");
		kennelService.updateKennelRname(kennel);
		return kennel.getId();
	}

	/*
	 * @Transactional(readOnly = false) public void updatePrintState(String id) { Kennel kennel =
	 * kennelService.get(id); kennel.setPrintState("1"); kennelService.save(kennel); }
	 */

	/*
	 * @Transactional(readOnly = false) public void updateFciPrintState(String id) { Kennel kennel =
	 * kennelService.get(id); kennel.setFciPrintState("1"); kennelService.save(kennel); }
	 */
	/**
	 * 
	 * @description: 犬舍名称变更业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月12日 下午5:35:28
	 */
	public void validateBusiness(KennelRename po) {
		Member member = UserUtils.getLoginMember();
		if (kennelDao.getKennelByMemberCode(member.getMemberCode()) == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员未注册犬舍");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已过期");
		}
		if (!MemberUtil.isProfessionalMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "不是专业会员");
		}
		// 中文、英文
		if (StringUtils.isNotBlank(po.getNewNameCn()) && isContainEnglish(po.getNewNameCn())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍中文名中包含英文，请修改");
		}
		if (StringUtils.isNotBlank(po.getNewNameEn()) && isChinese(po.getNewNameEn())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英文名中包含中文，请修改");
		}
		
		if(StringUtils.isNotBlank(po.getFciKennel()) && isChinese(po.getFciKennel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "FCI中包含中文，请修改");
		}
		if(StringUtils.isNotBlank(po.getFciKennelBackup()) && isChinese(po.getFciKennelBackup())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "备用FCI中包含中文，请修改");
		}
		// 查重
		if (StringUtils.isNotBlank(po.getNewNameCn()) && kennelDao.countByName("name", po.getNewNameCn(), member.getMemberCode()) > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍中文名重复");
		}
		if (StringUtils.isNotBlank(po.getNewNameEn()) && kennelDao.countByName("nameEn", po.getNewNameEn(), member.getMemberCode()) > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英文名重复");
		}
		if (StringUtils.isNotBlank(po.getFciKennel()) && kennelDao.countByName("fciName", po.getFciKennel(), member.getMemberCode()) > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍英文名重复");
		}
		
		Integer cardType = UserUtils.getMemberCardType(member);
		if(!"40".equals(cardType.toString()) && "1".equals(po.getMedalFlag()) ) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有紫金卡用户可选永久犬舍铜牌补做！");
		}
	}

	/**
	 * @description: 根据memberCode获取最近一条改名记录
	 * @author yuanshuai
	 * @data 2017年3月16日 下午3:34:39
	 */
	public KennelRename getTopByMemberCode(String memberCode) {
		return dao.findByMemberCode(memberCode);
	}

	/**
	 * 
	 * @description: 是否包含英文，包含返回true
	 * @author: laiguanglong
	 * @date: 2016年11月1日 上午10:30:36
	 */
	private boolean isContainEnglish(String str) {
		return str.matches("^[a-zA-Z]*");
	}

	private boolean isChinese(String str) {
		if(StringUtils.isNotBlank(str)) {
			String regEx = "[\\u4e00-\\u9fa5]+";
			Pattern p = Pattern.compile(regEx);
			Matcher m = p.matcher(str);
			if (m.find())
				return true;
			else
				return false;
		} else {
			return true;
		}
	}
}