package com.cku.oa.kennel.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.kennel.dao.KennelAllianceDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelAlliance;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 犬舍联盟Service
 * @author lgl
 * @version 2016-09-03
 */
@Service
@Transactional(readOnly = true)
public class KennelAllianceService extends CrudService<KennelAllianceDao, KennelAlliance> {
	
	@Autowired
	private KennelService kennelService;
	@Autowired
	private MemberService memberService;

	public KennelAlliance get(String id) {
		return super.get(id);
	}
	
	public List<KennelAlliance> findList(KennelAlliance kennelAlliance) {
		return super.findList(kennelAlliance);
	}
	
	public Page<KennelAlliance> findPage(Page<KennelAlliance> page, KennelAlliance kennelAlliance) {
		Page<KennelAlliance> result = super.findPage(page, kennelAlliance);
		for(KennelAlliance ka:result.getList()){
			ka.setKennel(kennelService.getKennelByMemberCode(ka.getMemberCode()));
		}
		return result;
	}
	
	@Transactional(readOnly = false)
	public void save(KennelAlliance kennelAlliance) {
		super.save(kennelAlliance);
	}
	
	@Transactional(readOnly = false)
	public void delete(KennelAlliance kennelAlliance) {
		super.delete(kennelAlliance);
	}
	
	
	public Map<String, Object> setMemberInfo(String memberCode) throws Exception {
		Map<String, Object> map = new HashMap<String, Object>();
		
		Member member = memberService.getByMemberCode(memberCode);
		if(member==null){
			map.put("status", 1);
			map.put("msg", "会员号有误!");
			return map;
		}
		map.put("memberName", member.getName());
		String memberFirstPaymentTime = "";
		if(member.getFirstPaymentTime()!=null){
			memberFirstPaymentTime = DateUtils.dateToStr(member.getFirstPaymentTime());
		}
		map.put("memberFirstPaymentTime", memberFirstPaymentTime);
		String memberGender = "";
		if(member.getGender()!=null&&"male".equals(member.getGender())){
			memberGender = "男";
		}
		if(member.getGender()!=null&&"female".equals(member.getGender())){
			memberGender = "女";
		}
		map.put("memberGender", memberGender);
		String memberBirthday = "";
		if(member.getBirthday()!=null){
			memberBirthday = DateUtils.dateToStr(member.getBirthday());
		}
		map.put("memberBirthday", memberBirthday);
		map.put("memberCardNo", member.getCardNo());
		map.put("memberMobile", member.getMobile());
		map.put("memberAddress", member.getProvince()+member.getCity()+member.getStreet()+member.getAddress());
		String memberMemberType = "";
		if(StringUtils.isNotBlank(member.getMemberType())){
			memberMemberType = member.getMemberType();
			if("basic".equals(member.getMemberType())){
				memberMemberType = "基础";
			}
			if("professional".equals(member.getMemberType())){
				memberMemberType = "专业";
			}
		}
		map.put("memberMemberType", memberMemberType);
		
		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
		if(kennel==null){
			map.put("status", 1);
			map.put("msg", "该会员没有相关的犬舍信息");
			return map;
		}
		String kennelType = "";
		if(StringUtils.isNotBlank(kennel.getType())){
			kennelType = kennel.getType();
			if("year".equals(kennel.getType())){
				kennelType = "年度";
			}
			if("permanent".equals(kennel.getType())){
				kennelType = "永久";
			}
		}
		map.put("kennelType", kennelType);
		map.put("kennelName", kennel.getName());
		map.put("kennelNameEn", kennel.getNameEn());
		map.put("kennelBreed", kennel.getBreed());
		String kennelEndTime = "";
		if(kennel.getEndTime()!=null){
			kennelEndTime = DateUtils.dateToStr(kennel.getEndTime());
		}
		map.put("kennelEndTime", kennelEndTime);
		
		return map;
	}
	
	/**
	 * 
	 * @description: 录入犬舍联盟信息
	 * @author: laiguanglong
	 * @date: 2016年9月5日 下午3:35:17
	 */
	@Transactional(readOnly = false)
	public void add(KennelAlliance add) throws ZAException {
		
		//判断是否已录入
		KennelAlliance ka = dao.getByMemberCode(add.getMemberCode());
		if(ka!=null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该会员已登记犬舍联盟，请勿重复登记");
		}
		
		//保存犬舍联盟信息
		KennelAlliance kennelAlliance = new KennelAlliance();
		kennelAlliance.setMemberCode(add.getMemberCode());
		kennelAlliance.setProject(add.getProject());
		kennelAlliance.setCombo(add.getCombo());
		kennelAlliance.setOperator(add.getOperator());
		kennelAlliance.setPayAmount(add.getPayAmount());
		//当前时间
		kennelAlliance.setStartDate(new Date());
		//录入的时候不填结束时间，所以还是未生效，只有缴费后在把结束时间设为年底
//		kennelAlliance.setEndDate(add.getEndDate());
		kennelAlliance.setRemarks(add.getRemarks());
		super.save(kennelAlliance);
		
		//更新cku_user表qslz_tag、qslz_time字段，根据userid，只有缴费后才更新，故此处不更新
//		dao.updateMember(kennelAlliance);
	}
	
	/**
	 * 
	 * @description: 修改犬舍联盟信息
	 * @author: laiguanglong
	 * @date: 2016年9月5日 下午4:00:05
	 */
	@Transactional(readOnly = false)
	public void edit(KennelAlliance edit) throws ZAException {
		
		//判断是否已录入
		KennelAlliance kennelAlliance = dao.getByMemberCode(edit.getMemberCode());
		if(kennelAlliance==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该犬舍联盟不存在");
		}
		
		//更新犬舍联盟信息
		kennelAlliance.setMemberCode(edit.getMemberCode());
		kennelAlliance.setProject(edit.getProject());
		kennelAlliance.setCombo(edit.getCombo());
		kennelAlliance.setOperator(edit.getOperator());
		kennelAlliance.setPayAmount(edit.getPayAmount());
		kennelAlliance.setStartDate(edit.getStartDate());
		kennelAlliance.setEndDate(edit.getEndDate());
		kennelAlliance.setRemarks(edit.getRemarks());
		super.save(kennelAlliance);
		
		//更新cku_user表qslz_tag、qslz_time字段，根据userid，只有缴费后才更新，故此处不更新
//		dao.updateMember(kennelAlliance);
	}

	/**
	 * @description: 判断是否有效犬舍联盟，返回true表示是
	 * @author: laiguanglong
	 * @date: 2016/12/28 17:44
	 */
	public boolean isKennelAlliance(String memberCode){
		boolean flag = false;
		long now = new Date().getTime();
		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
		if(kennel!=null&&kennel.getEndTime()!=null&&kennel.getEndTime().getTime()>now){
			KennelAlliance kennelAlliance = dao.getByMemberCode(memberCode);
			if(kennelAlliance!=null&&kennelAlliance.getStartDate().getTime()<now&&kennelAlliance.getEndDate()!=null&&kennelAlliance.getEndDate().getTime()>now){
				flag = true;
			}
		}
		return flag;
	}

	/**
	 * @description: 加急费用是否免收，返回true表示免收加急费
	 * @author: laiguanglong
	 * @date: 2016/12/30 10:42
	 */
	public boolean isUrgentFree(String memberCode){
		boolean flag = false;
		long now = System.currentTimeMillis();
		//不校验犬舍是否有效，因为配种证明、出生证明申请业务已经校验母犬主有犬舍，且犬舍有效
//		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
//		if(kennel!=null&&kennel.getEndTime()!=null&&kennel.getEndTime().getTime()>now){
			KennelAlliance kennelAlliance = dao.getByMemberCode(memberCode);
			if(kennelAlliance!=null&&"0".equals(kennelAlliance.getDelFlag())&&kennelAlliance.getStartDate().getTime()<now&&kennelAlliance.getEndDate()!=null&&kennelAlliance.getEndDate().getTime()>now){
				if("12000".equals(kennelAlliance.getCombo())){
					flag = true;
				}
			}
//		}
		return flag;
	}
}