/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬舍联盟Entity
 * @author lgl
 * @version 2016-09-03
 */
public class KennelAlliance extends DataEntity<KennelAlliance> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String project;		// 所属项目
	private String combo;		// 套餐
	private String operator;		// 经办人
	private String payAmount;		// 缴费金额
	private Date startDate;		// 有效期开始时间
	private Date endDate;		// 有效期结束时间
	
	private Member member;		//会员信息
	private Kennel kennel;		//犬舍信息
	
	public KennelAlliance() {
		super();
	}

	public KennelAlliance(String id){
		super(id);
	}

	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=50, message="所属项目长度必须介于 0 和 50 之间")
	public String getProject() {
		return project;
	}

	public void setProject(String project) {
		this.project = project;
	}
	
	@Length(min=0, max=50, message="套餐长度必须介于 0 和 50 之间")
	public String getCombo() {
		return combo;
	}

	public void setCombo(String combo) {
		this.combo = combo;
	}
	
	@Length(min=0, max=50, message="经办人长度必须介于 0 和 50 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	public String getPayAmount() {
		return payAmount;
	}

	public void setPayAmount(String payAmount) {
		this.payAmount = payAmount;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Kennel getKennel() {
		return kennel;
	}

	public void setKennel(Kennel kennel) {
		this.kennel = kennel;
	}
	
	private String valid;		//是否有效	0:有效；1:无效

	public String getValid() {
		if(id!=null){
			if(startDate!=null&&endDate!=null){
				Date date = new Date();
				if(date.after(startDate)&&date.before(endDate)){
					return "0";
				}else{
					return "1";
				}
			}
			if(endDate==null){
				return "1";
			}
		}
		return valid;
	}

	public void setValid(String valid) {
		this.valid = valid;
	}
}