package com.cku.oa.goods.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.goods.entity.SysBusinessService;
import com.cku.oa.goods.service.SysBusinessServiceService;
import com.cku.oa.order.entity.BusinessOrder;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.goods.entity.SysBusinessCate;
import com.cku.oa.goods.service.SysBusinessCateService;

import java.util.List;

/**
 * 业务分类Controller
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@Controller
@RequestMapping(value = "${adminPath}/goods/sysBusinessCate")
public class SysBusinessCateController extends BaseController {

	@Autowired
	private SysBusinessCateService sysBusinessCateService;

	@ModelAttribute
	public SysBusinessCate get(@RequestParam(required = false) String id) {
		SysBusinessCate entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = sysBusinessCateService.get(id);
		}
		if (entity == null) {
			entity = new SysBusinessCate();
		}
		return entity;
	}

	@RequiresPermissions("goods:sysBusinessCate:view")
	@RequestMapping(value = {"list", ""})
	public String list(SysBusinessCate sysBusinessCate, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysBusinessCate> page = sysBusinessCateService.findPage(new Page<>(request, response), sysBusinessCate);
		model.addAttribute("page", page);
		return "oa/goods/sysBusinessCateList";
	}

	@RequiresPermissions("goods:sysBusinessCate:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(SysBusinessCate sysBusinessCate, Model model) {
		model.addAttribute("isView", 1);
		model.addAttribute("sysBusinessCate", sysBusinessCate);
		return "oa/goods/sysBusinessCateForm";
	}

	@RequiresPermissions("goods:sysBusinessCate:edit")
	@RequestMapping(value = "editForm")
	public String editForm(SysBusinessCate sysBusinessCate, Model model) {
		model.addAttribute("isView", 0);
		model.addAttribute("sysBusinessCate", sysBusinessCate);
		return "oa/goods/sysBusinessCateForm";
	}

	@RequiresPermissions("goods:sysBusinessCate:edit")
	@RequestMapping(value = "save")
	public String save(SysBusinessCate sysBusinessCate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysBusinessCate)) {
			return editForm(sysBusinessCate, model);
		}
		try {
			sysBusinessCateService.save(sysBusinessCate);
			addMessage(redirectAttributes, "保存业务分类成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "保存业务分类失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sysBusinessCate/?repage";
	}

	@RequiresPermissions("goods:sysBusinessCate:del")
	@RequestMapping(value = "delete")
	public String delete(SysBusinessCate sysBusinessCate, RedirectAttributes redirectAttributes) {
		try {
			sysBusinessCateService.delete(sysBusinessCate);
			addMessage(redirectAttributes, "删除业务分类成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除业务分类失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sysBusinessCate/?repage";
	}

}