package com.cku.oa.gcWeb.web;

import com.cku.oa.gcWeb.entity.GCWebTalent;
import com.cku.oa.gcWeb.service.GCWebTalentService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 美容师人才库Controller
 * @author yuanshuai
 * @version 2023-01-30
 */
@Controller
@RequestMapping(value = "${adminPath}/gcWeb/talent")
public class GCWebTalentController extends BaseController {

	@Autowired
	private GCWebTalentService gcWebTalentService;
	
	@ModelAttribute
	public GCWebTalent get(@RequestParam(required=false) String id) {
		GCWebTalent entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = gcWebTalentService.get(id);
		}
		if (entity == null){
			entity = new GCWebTalent();
		}
		return entity;
	}
	
	@RequiresPermissions("gcWeb:talent:view")
	@RequestMapping(value = {"list", ""})
	public String list(GCWebTalent gcWebTalent, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GCWebTalent> page = gcWebTalentService.findPage(new Page<>(request, response), gcWebTalent);
		model.addAttribute("gcWebTalent", gcWebTalent);
		model.addAttribute("page", page);
		return "oa/gcWeb/gcWebTalentList";
	}

	@RequiresPermissions("gcWeb:talent:view")
	@RequestMapping(value = "form")
	public String form(GCWebTalent gcWebTalent, Model model) {
		model.addAttribute("gcWebTalent", gcWebTalent);
		return "oa/gcWeb/gcWebTalentForm";
	}

	@RequiresPermissions("gcWeb:talent:edit")
	@RequestMapping(value = "save")
	public String save(GCWebTalent gcWebTalent, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, gcWebTalent)){
			return form(gcWebTalent, model);
		}
		if (StringUtils.isNotBlank(gcWebTalent.getCv())) {
			gcWebTalent.setCv(StringEscapeUtils.unescapeHtml4(gcWebTalent.getCv()));
		}
		if (StringUtils.isNotBlank(gcWebTalent.getGroomer())) {
			gcWebTalent.setGroomer(StringEscapeUtils.unescapeHtml4(gcWebTalent.getGroomer()));
		}
		if (StringUtils.isNotBlank(gcWebTalent.getReferee())) {
			gcWebTalent.setReferee(StringEscapeUtils.unescapeHtml4(gcWebTalent.getReferee()));
		}
		if (StringUtils.isNotBlank(gcWebTalent.getBreed())) {
			gcWebTalent.setBreed(StringEscapeUtils.unescapeHtml4(gcWebTalent.getBreed()));
		}
		gcWebTalentService.save(gcWebTalent);
		addMessage(redirectAttributes, "保存美容官网人才库成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/talent/?repage";
	}
	
	@RequiresPermissions("gcWeb:talent:del")
	@RequestMapping(value = "delete")
	public String delete(GCWebTalent gcWebTalent, RedirectAttributes redirectAttributes) {
		gcWebTalentService.delete(gcWebTalent);
		addMessage(redirectAttributes, "删除美容官网人才库成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/talent/?repage";
	}

}