/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 财务系统映射收费项条目Entity
 * @author 财务系统映射收费项条目
 * @version 2019-09-22
 */
public class SaFinanceSubjectMappingItem extends DataEntity<SaFinanceSubjectMappingItem> {
	
	private static final long serialVersionUID = 1L;
	private String mappingId;		// 映射id
	private String chargingItemId;		// 三级收费项id
	
	public SaFinanceSubjectMappingItem() {
		super();
	}

	public SaFinanceSubjectMappingItem(String id){
		super(id);
	}

	@Length(min=1, max=100, message="映射id长度必须介于 1 和 100 之间")
	public String getMappingId() {
		return mappingId;
	}

	public void setMappingId(String mappingId) {
		this.mappingId = mappingId;
	}
	
	@Length(min=1, max=100, message="三级收费项id长度必须介于 1 和 100 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}
	
}