/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 购物车Entity
 * @author fanhuibin
 * @version 2016-09-20
 */
public class PaymentCart extends DataEntity<PaymentCart> {

	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String memberName;		// member_name
	private String chargingItemId;		// 收费项目id
	private String chargingItemName;		// charging_item_name
	private String num;		// 数量
	private String price;		// 单价
	private String totalPrice;		// 总价
	private Date addTime;		// 添加时间
	private String businessOrderCode;		// 业务号
	private String businessTable;		// 业务表名
	private String businessIds;		// 业务表ids
	private String token; //宠爱王国访问令牌
	private String couponNum; //优惠数量
	private String businessName ;//业务名字
	private String businessId;//业务序号
	private String businessRefund;//业务退款  0不支持,1支持

	public String getBusinessRefund() {
		return businessRefund;
	}

	public void setBusinessRefund(String businessRefund) {
		this.businessRefund = businessRefund;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public PaymentCart() {
		super();
	}

	public PaymentCart(String id){
		super(id);
	}

	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min=0, max=100, message="member_name长度必须介于 0 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min=0, max=64, message="收费项目id长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	@Length(min=0, max=100, message="charging_item_name长度必须介于 0 和 100 之间")
	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}

	@Length(min=0, max=11, message="数量长度必须介于 0 和 11 之间")
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	public String getBusinessOrderCode() {
		return businessOrderCode;
	}

	public void setBusinessOrderCode(String businessOrderCode) {
		this.businessOrderCode = businessOrderCode;
	}

	@Length(min=0, max=200, message="业务表名长度必须介于 0 和 200 之间")
	public String getBusinessTable() {
		return businessTable;
	}

	public void setBusinessTable(String businessTable) {
		this.businessTable = businessTable;
	}

	public String getBusinessIds() {
		return businessIds;
	}

	public void setBusinessIds(String businessIds) {
		this.businessIds = businessIds;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getCouponNum() {
		return couponNum;
	}

	public void setCouponNum(String couponNum) {
		this.couponNum = couponNum;
	}
}