package com.cku.oa.dog.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedRedoDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.finance.service.OADeleteService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 证书补做Service
 * @author lgl
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class DogPedigreeCertifiedRedoService extends CrudService<DogPedigreeCertifiedRedoDao, DogPedigreeCertifiedRedo> {

	private static final String BUSINESS_NAME = "证书补做";

	@Autowired
	private DogService dogService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private RemindService remindService;
	@Autowired
	private DogTypeService dogTypeService;
    @Autowired
    private DogDnaService dogDnaService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private OADeleteService oADeleteService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private DogStickerApplyService dogStickerApplyService;
	@Autowired
	private MemberService memberService;

	public DogPedigreeCertifiedRedo get(String id) {
		return super.get(id);
	}

	public List<DogPedigreeCertifiedRedo> findList(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
    	if(StringUtils.isBlank(dogPedigreeCertifiedRedo.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogPedigreeCertifiedRedo.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogPedigreeCertifiedRedo.getSqlMap().put("dogBreedMap", " ='"+dogPedigreeCertifiedRedo.getDogBreed()+"'");
    	}
		return super.findList(dogPedigreeCertifiedRedo);
	}

	public Page<DogPedigreeCertifiedRedo> findPage(Page<DogPedigreeCertifiedRedo> page, DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
    	if(StringUtils.isBlank(dogPedigreeCertifiedRedo.getDogBreed())){
    		//根据当前登录端查询犬种
    		dogPedigreeCertifiedRedo.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		dogPedigreeCertifiedRedo.getSqlMap().put("dogBreedMap", " ='"+dogPedigreeCertifiedRedo.getDogBreed()+"'");
    	}
		return super.findPage(page, dogPedigreeCertifiedRedo);
	}

	@Transactional(readOnly = false)
	public void save(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
		super.save(dogPedigreeCertifiedRedo);
	}

	@Transactional(readOnly = false)
	public void delete(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
		//已缴费的订单不允许删除
		if("2".equals(dogPedigreeCertifiedRedo.getPaymentState())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		//OA删除订单
		oADeleteService.deleteUnpay(dogPedigreeCertifiedRedo.getPaymentState(), "dog_pedigree_certified_redo", dogPedigreeCertifiedRedo.getId(), dogPedigreeCertifiedRedo.getRunningNumber());
		//如果是oa报名的话，没有订单，故没走上面的删除，所以需要再次删除
		super.delete(dogPedigreeCertifiedRedo);
	}

	/**
	 *
	 * @description: 证书补做审核
	 * @author: laiguanglong
	 * @date: 2016年8月18日 下午5:15:58
	 */
	@Transactional(readOnly = false)
	public void audit(DogPedigreeCertifiedRedo audit) throws ZAException {
		try {
			DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = super.get(audit.getId());
			if("3".equals(dogPedigreeCertifiedRedo.getReviewState())){
				dogPedigreeCertifiedRedo.setReviewState("0");
			}
			SysContext sysContext = new SysContext(dogPedigreeCertifiedRedo.getPaymentState(),dogPedigreeCertifiedRedo.getReviewState(),dogPedigreeCertifiedRedo.getProcessState());
			if("1".equals(audit.getReviewState())){
				//已审核
				dogPedigreeCertifiedRedo.setReviewState("1");
				sysContext.confirmSuccess(sysContext,BUSINESS_NAME,dogPedigreeCertifiedRedo.getPaymentMemberCode(),"dog_pedigree_certified_redo",dogPedigreeCertifiedRedo.getId(),dogPedigreeCertifiedRedo.getRunningNumber(),(str)->{});
			}else if("2".equals(audit.getReviewState())){
				//已撤销
				dogPedigreeCertifiedRedo.setReviewState("2");
				sysContext.confirmFail(sysContext, BUSINESS_NAME,audit.getReviewRemarks(), dogPedigreeCertifiedRedo.getPaymentMemberCode(),"dog_pedigree_certified_redo",dogPedigreeCertifiedRedo.getId(),dogPedigreeCertifiedRedo.getRunningNumber(),(str)->{});
			}else if("3".equals(audit.getReviewState())){
				dogPedigreeCertifiedRedo.setReviewState("3");
				sysContext.confirmFail(sysContext, BUSINESS_NAME,audit.getReviewRemarks(),dogPedigreeCertifiedRedo.getPaymentMemberCode(),"dog_pedigree_certified_redo",dogPedigreeCertifiedRedo.getId(),dogPedigreeCertifiedRedo.getRunningNumber(), (str)->{});
			}
			dogPedigreeCertifiedRedo.setReviewRemarks(audit.getReviewRemarks());
			dogPedigreeCertifiedRedo.setReviewTime(new Date());
			super.save(dogPedigreeCertifiedRedo);
			//给用户发送消息
			sendMsg(dogPedigreeCertifiedRedo);
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 *
	 * @description: 证书补做处理
	 * @author: laiguanglong
	 * @date: 2016年8月15日 下午5:35:56
	 */
	@Transactional(readOnly = false)
	public void resolve(DogPedigreeCertifiedRedo resolve) throws ZAException {
		try {
			DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = super.get(resolve.getId());
			SysContext sysContext = new SysContext(dogPedigreeCertifiedRedo.getPaymentState(),dogPedigreeCertifiedRedo.getReviewState(),dogPedigreeCertifiedRedo.getProcessState());
			sysContext.updateData(sysContext,BUSINESS_NAME,dogPedigreeCertifiedRedo.getPaymentMemberCode(),"dog_pedigree_certified_redo",dogPedigreeCertifiedRedo.getId(),dogPedigreeCertifiedRedo.getRunningNumber(),(str)->{});
			Dog dog = dogService.get(dogPedigreeCertifiedRedo.getDogId());
			dogPedigreeCertifiedRedo.setDogGender(dog.getGender());
			//丢失补做重新生成新证书号,变更登录补做不变
			if("2".equals(dogPedigreeCertifiedRedo.getChangeType().trim())){
				dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(SysCodeUtil.getPedigreeCertifiedCode(dog.getDogBreed()));
				//更新血统证书涉及的表
				updatePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
				//丢失补做则注销参赛券
				deleteSysCoupon(dogPedigreeCertifiedRedo);
			}else{
				//纸质证书补做为原号补做，证书号不变
				if("4".equals(dogPedigreeCertifiedRedo.getChangeType().trim())){
					dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
				}else{
					//如果犬种为藏獒，且血统证书不为CKUTM开头，需要从新生成新证书号
					if("230".equals(dog.getDogBreed().trim())
							&&dog.getPedigreeCertifiedCode().startsWith("CKU")
							&&!dog.getPedigreeCertifiedCode().startsWith("CKUTM")){
						dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(SysCodeUtil.getPedigreeCertifiedCode(dog.getDogBreed()));
						//更新血统证书涉及的表
						updatePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
						//藏獒血统证书号改变之后更新参赛券
						updateSysCoupon(dogPedigreeCertifiedRedo);
					}else if("292".equals(dog.getDogBreed().trim())//如果犬种为杜高，血统证书号已CKU开头且血统证书不为CKUDC开头，需要修改血统证书号,只把CKU改为CKUDC
							&&dog.getPedigreeCertifiedCode().startsWith("CKU")
							&&!dog.getPedigreeCertifiedCode().startsWith("CKUDC")
							&&System.currentTimeMillis()>SysCodeUtil.duGaoTimeMillis){
						dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified().replace("CKU","CKUDC"));
						//更新血统证书涉及的表
						updatePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
						//杜高犬血统证书号改变之后更新参赛券
						updateSysCoupon(dogPedigreeCertifiedRedo);
					}else if("15C".equals(dog.getDogBreed().trim())//如果犬种为玛犬，血统证书号已CKU开头且血统证书不为CKUMC开头，需要修改血统证书号,只把CKU改为CKUMC
							&&dog.getPedigreeCertifiedCode().startsWith("CKU")
							&&!dog.getPedigreeCertifiedCode().startsWith("CKUMC")){
						dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified().replace("CKU","CKUMC"));
						//更新血统证书涉及的表
						updatePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
						//玛犬血统证书号改变之后更新参赛券
						updateSysCoupon(dogPedigreeCertifiedRedo);
					}else{
						dogPedigreeCertifiedRedo.setCurrentPedigreeCertified(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
					}
				}

			}
			//修改证书补做记录状态信息
			updateDogPedigreeCertifiedRedo(dogPedigreeCertifiedRedo);
			//修改犬只信息：证书号，打印状态 呼名
			updateDog(dogPedigreeCertifiedRedo, dog);
			//证书补做处理后重置打印状态由于dog表update的方法不更新打印状态，所以需要再次单独调用
			dog.setPrintState(getResetPrintState(dog));
			dog.setOperator(UserUtils.getLoginUser().getName());
			dogDao.updatePrintState(dog);
			//修改dogchip表呼名
			String birthCertificateLevelCode = dog.getBirthCertificateLevelCode();
			if(StringUtils.isNotBlank(birthCertificateLevelCode)){
				DogChip dogChip = dogChipDao.getByBirthCode(birthCertificateLevelCode);
				if(dogChip != null){
					dogChip.setCallName(dogPedigreeCertifiedRedo.getCallName());
					//纸质证书补做后将电子证书改为纸质证书
					if("4".equals(dogPedigreeCertifiedRedo.getChangeType())) {
						dogChip.setEcertFlag("0");
					}
					dogChipDao.update(dogChip);
				}
			}
			//等级贴纸业务
			// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//			if ("1".equals(dogPedigreeCertifiedRedo.getStickerFlag())) {
//				dogStickerApplyService.applySticker(dog, dogPedigreeCertifiedRedo.getPaymentMemberCode(), dogPedigreeCertifiedRedo.getRunningNumber());
//			}
		} catch (Exception e) {
			throw e;
		}
	}

	private String getResetPrintState(Dog dog){
		String printState = dog.getPrintState();
		if(StringUtils.isNotBlank(dog.getPrintState())){
			if(dog.getPrintState().contains("1")){
				printState = "1";
			}else if(dog.getPrintState().contains("2")){
				printState = "2";
			}else if(dog.getPrintState().contains("3")){
				printState = "3";
			}
		}
		return printState;
	}

	/**
	 *
	 * @description: 修改证书补做记录状态信息
	 * @author: laiguanglong
	 * @date: 2016年8月12日 上午11:31:03
	 */
	private void updateDogPedigreeCertifiedRedo(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo){
		dogPedigreeCertifiedRedo.setProcessState("1");
		dogPedigreeCertifiedRedo.setProcessTime(new Date());
		super.save(dogPedigreeCertifiedRedo);
	}

	/**
	 *
	 * @description: 修改犬只信息：证书号，打印状态，呼名
	 * @author: laiguanglong
	 * @date: 2016年8月12日 上午11:29:10
	 */
	private void updateDog(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo,Dog dog){
		//修改呼名
		dog.setCallName(dogPedigreeCertifiedRedo.getCallName() == null ? "" : dogPedigreeCertifiedRedo.getCallName());

		dog.setPedigreeCertifiedOld(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
		dog.setPedigreeCertifiedCode(dogPedigreeCertifiedRedo.getCurrentPedigreeCertified());
		String fdogPedigreeCertified = dog.getFdogPedigreeCertified();
		String mdogPedigreeCertified = dog.getMdogPedigreeCertified();
		if (StringUtils.isBlank(fdogPedigreeCertified) || "-".equals(fdogPedigreeCertified)
				|| StringUtils.isBlank(mdogPedigreeCertified) || "-".equals(mdogPedigreeCertified)) {
			dog.setPrintState("1");
		} else if (Objects.nonNull(dog.getGoldCertifiedType())
				&& Objects.nonNull(dog.getGoldCertifiedState())
				&& (1 == dog.getGoldCertifiedType() || 2 == dog.getGoldCertifiedType())
				&& 0 == dog.getGoldCertifiedState()) {
			//金质证书降级-打印鉴定证书
			dog.setPrintState("1");
		} else {
			dog.setPrintState("2");
		}
		//纸质证书补做后将电子证书改为纸质证书
		if("4".equals(dogPedigreeCertifiedRedo.getChangeType())) {
			dog.setEcertFlag("0");
		}
		dogService.save(dog);
	}

	/**
	 *
	 * @description: 更新血统证书涉及的表
	 * @author: laiguanglong
	 * @date: 2016年8月12日 上午10:54:48
	 */
	public void updatePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo){
		dao.updateDogTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogBirthCertificateTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogNewbornTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateShowResultsTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateChampionLoginTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogNewbornPedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogAppraisalPedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateShowScoreRankingTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		//dna存档&血样留存&双亲比对
		dao.updateDogDnaArchiveTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogBloodSaveTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		dao.updateDogDnaParentsCompareTablePedigreeCertifiedCode(dogPedigreeCertifiedRedo);
		
		//TODO 更改新生犬登记表中的血统证书号
	}
	/**
	 *
	 * @description: 变更登陆补做
	 * @author: zhangxinag
	 * @date: 2019年2月27日 下午3:03:34
	 */
	public void updateSysCoupon(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo){
		//更新参赛券
		SysCoupon sysCoupon=new SysCoupon();
		sysCoupon.setTargetId(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
		List<SysCoupon> sList=sysCouponService.findList(sysCoupon);
		for(int i=0;i<sList.size();i++){
			SysCoupon sys=sList.get(i);
			if(sys.getCouponName().equals("CAC赛事免费参赛券")||sys.getCouponName().equals("CAC犬展免费参展券")){
				sys.setTargetId(dogPedigreeCertifiedRedo.getCurrentPedigreeCertified());
				sys.setExplains("参展券限CKU血统证书为："+dogPedigreeCertifiedRedo.getCurrentPedigreeCertified()+"的犬只使用");
				sysCouponService.save(sys);
			}
		}
	}
	/**
	 *
	 * @description: 丢失补做删除参赛券
	 * @author: zhangxinag
	 * @date: 2019年2月27日 下午3:03:34
	 */
	public void deleteSysCoupon(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo){
		//更新参赛券
		SysCoupon sysCoupon=new SysCoupon();
		sysCoupon.setTargetId(dogPedigreeCertifiedRedo.getOriginalPedigreeCertified());
		List<SysCoupon> sList=sysCouponService.findList(sysCoupon);
		for(int i=0;i<sList.size();i++){
			SysCoupon sys=sList.get(i);
			if(sys.getCouponName().equals("CAC赛事免费参赛券")||sys.getCouponName().equals("CAC犬展免费参展券")){
				sysCouponService.delete(sys);
			}
		}
	}
	/**
	 *
	 * @description: 添加证书补做订单页面，根据血统证书号查询犬只信息
	 * @author: laiguanglong
	 * @date: 2016年8月24日 下午3:03:34
	 */
	public HashMap<String,String> getDogByPedigreeCertified(String pedigreeCertified){
		HashMap<String,String> map = new HashMap<String,String>();
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		if(dog!=null){
			map.put("dogId", dog.getId());
			map.put("nameEn", dog.getNameEn());
			map.put("birthdate", DateUtils.dateToStr(dog.getBirthdate()));
			map.put("gender", DictUtils.getDictLabel(dog.getGender(), "dog_gender", ""));
			DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
			if(dogType!=null){
				map.put("dogBreed", dogType.getBreedCnName());
			}
		}
		return map;
	}

	/**
	 *
	 * @description: 证书补做录入
	 * @author: laiguanglong
	 * @date: 2016年8月19日 上午10:46:29
	 */
	@Transactional(readOnly = false,rollbackFor=Exception.class)
	public void add(DogPedigreeCertifiedRedo redo) throws ZAException {
		//证书补做业务校验
		Dog dog = validateBusiness(redo);

		DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = new DogPedigreeCertifiedRedo();
		dogPedigreeCertifiedRedo.setDogId(dog.getId());
		dogPedigreeCertifiedRedo.setOriginalPedigreeCertified(dog.getPedigreeCertifiedCode());
		dogPedigreeCertifiedRedo.setPaymentMemberCode(dog.getMemberCode());
		dogPedigreeCertifiedRedo.setReviewState("0");
		dogPedigreeCertifiedRedo.setProcessState("0");
		dogPedigreeCertifiedRedo.setPaymentState("2");
		dogPedigreeCertifiedRedo.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(redo.getRunningNumber()));
		dogPedigreeCertifiedRedo.setRunningNumber(redo.getRunningNumber());
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get("25");
		dogPedigreeCertifiedRedo.setPrice(paymentChargingItem.getPrice());
		dogPedigreeCertifiedRedo.setChangeType(redo.getChangeType());
		dogPedigreeCertifiedRedo.setCallName(redo.getCallName());
		super.save(dogPedigreeCertifiedRedo);

		//给用户发送消息
		sendMsg(dogPedigreeCertifiedRedo);
	}

	/**
	 *
	 * @description: 证书补做业务校验
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午6:29:59
	 */
	public Dog validateBusiness(DogPedigreeCertifiedRedo redo) throws ZAException {
		Dog dog = dogService.get(redo.getDogId());
		if(dog==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书号有误");
		}
		if(!"0".equals(dog.getDelFlag())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经标记为删除");
		}
		if(!redo.getPaymentMemberCode().equals(dog.getMemberCode())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬主人不为于申请人");
		}
		//藏獒提交证书补做时，需完成DNA位点分析(DNA存档)
		if("230".equals(dog.getDogBreed())&&!dogDnaService.isHaveDogDna(dog.getId())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该藏獒未完成DNA位点分析，不允许申请证书补做");
		}
		Member member = memberService.getByMemberCode(dog.getMemberCode());
//		if(member != null && (member.getMemberEndDate() == null  || new Date().getTime() > member.getMemberEndDate().getTime())){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该会员为无效会员，不允许申请证书补做");
//		}
		if(!MemberUtil.isActiveMember(member)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的会员身份已经过期，无法办理该业务");
		}
		//校验重复订单
		DogPedigreeCertifiedRedo example = new DogPedigreeCertifiedRedo();
		example.setDogId(redo.getDogId());
		example.setPaymentMemberCode(dog.getMemberCode());
		//未处理的订单
		example.setProcessState("0");
		List<DogPedigreeCertifiedRedo> dogPedigreeCertifiedRedoList = super.findList(example);
		for(Iterator<DogPedigreeCertifiedRedo> it = dogPedigreeCertifiedRedoList.iterator(); it.hasNext();) {
			DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = it.next();
			if("2".equals(dogPedigreeCertifiedRedo.getReviewState())){
				//排除已注销的记录
				it.remove();
			}
		}
		if(dogPedigreeCertifiedRedoList.size()!=0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只有未处理的证书补做订单");
		}
		if(StringUtils.isNotBlank(redo.getCallName())){
			demandSensitiveWordService.validCallName(redo.getCallName());
		}
		//犬只状态为已出口
		if("5".equals(dog.getDogState())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"犬只状态为已出口，不允许申请补做");
		}
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(redo.getStickerFlag())){
//			//等级贴纸申请基础校验
//			dogStickerApplyService.basicValidate(dog.getIdentificationFlag(), UserUtils.getLoginMember().getMemberCode());
//		}
		return dog;
	}

	/**
	 *
	 * @description: 根据新血统证书号进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月2日 下午5:23:58
	 */
	public DogPedigreeCertifiedRedo getByCurrentPedigreeCertified(String currentPedigreeCertified){
		return dao.getByCurrentPedigreeCertified(currentPedigreeCertified);
	}

	/**
	 *
	 * @description: 给用户发送消息，根据审核状态和补做类型来判断发送内容
	 * @author: laiguanglong
	 * @date: 2016年8月19日 上午10:25:16
	 */
	private void sendMsg(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo){
		String reviewState = dogPedigreeCertifiedRedo.getReviewState();
		//只有0，1，2的状态发消息
		if("0".equals(reviewState)||"1".equals(reviewState)||"2".equals(reviewState)){
			String content = null;
			String changeType = dogPedigreeCertifiedRedo.getChangeType();
			String changeTypeLabel = DictUtils.getDictLabel(changeType, "dog_pedigree_certified_redo_type", "补做");
			if("0".equals(reviewState)){
				//未审核状态，提交未缴费
				SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
				String dateString = formatter.format(new Date());
				content = "您于"+dateString+"提交了血统证书编号为“"+dogPedigreeCertifiedRedo.getOriginalPedigreeCertified()+"”证书"+changeTypeLabel+"申请，请您务必于当日24时前完成缴费，过期订单失效哦。";
			}else if("1".equals(reviewState)){
				//审核通过
				content = "您提交的血统证书编号为“"+dogPedigreeCertifiedRedo.getOriginalPedigreeCertified()+"”的证书"+changeTypeLabel+"申请审核通过，请注意查收邮件。";
			}else if("2".equals(reviewState)){
				//审核不通过
				content = "您提交的血统证书编号为“"+dogPedigreeCertifiedRedo.getOriginalPedigreeCertified()+"”的证书"+changeTypeLabel+"审核未通过，请修改后重新提交。";
			}
			remindService.addRemind(content, dogPedigreeCertifiedRedo.getPaymentMemberCode());
		}
	}

	/**
	 *
	 * @description: 获取已付款待审核的证书补做申请记录数
	 * @author: laiguanglong
	 * @date: 2016年8月29日 下午4:04:56
	 */
	public int getAuditCount(){
		DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = new DogPedigreeCertifiedRedo();
		//已付款
		dogPedigreeCertifiedRedo.setPaymentState("2");
		//未审核
		dogPedigreeCertifiedRedo.setReviewState("0");
		return dao.listCount(dogPedigreeCertifiedRedo);
	}
}