package com.cku.oa.dog.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogNoseDao;
import com.cku.oa.dog.dao.DogNoseResultDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogNoseResult;
import com.cku.oa.dog.vo.MatchChipNoResponseVo;
import com.cku.restful.v1.dog.vo.MatchChipNoVo;
import com.cku.restful.v1.dog.vo.NoseMatchVo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 鼻纹识别结果Service
 * 
 * @author zhaoxy
 * @version 2020-11-30
 */
@Service
@Transactional(readOnly = true)
public class DogNoseResultService extends CrudService<DogNoseResultDao, DogNoseResult> {

	@Autowired
	private DogDao dogDao;

	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;

	@Autowired
	private DogNoseDao dogNoseDao;

	public DogNoseResult get(String id) {
		return super.get(id);
	}

	public List<DogNoseResult> findList(DogNoseResult dogNoseResult) {
		return super.findList(dogNoseResult);
	}

	public Page<DogNoseResult> findPage(Page<DogNoseResult> page, DogNoseResult dogNoseResult) {
		return super.findPage(page, dogNoseResult);
	}

	@Transactional(readOnly = false)
	public void save(DogNoseResult dogNoseResult) {
		super.save(dogNoseResult);
	}

	@Transactional(readOnly = false)
	public void delete(DogNoseResult dogNoseResult) {
		super.delete(dogNoseResult);
	}

	/**
	 * 1:N匹配结果
	 */
	public List<MatchChipNoResponseVo> matchChipNo(NoseMatchVo vo) {
//		MatchChipNoListResponseVo matchChipNoListResponseVo = new MatchChipNoListResponseVo();
		List<MatchChipNoResponseVo> respList = new ArrayList<>();
		
//		for (MatchChipNoVo obj : vo.getNoseIds()) {
		for (int i = 0; i < vo.getNoseIds().size(); i++) {
			MatchChipNoVo obj = vo.getNoseIds().get(i);
			MatchChipNoResponseVo resp = new MatchChipNoResponseVo();
			DogNose dogNose = dogNoseDao.getByNoseId(obj.getNoseId());
			if (!ObjectUtils.isEmpty(dogNose)) {
				if (!StringUtils.isEmpty(dogNose.getDogBirthCertificateId())) {
					DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
							.get(dogNose.getDogBirthCertificateId());
					resp.setSort("TOP" + (i + 1));
					resp.setChipNo(dogBirthCertificate.getIdentificationFlag());
					resp.setNoseId(obj.getNoseId());
					resp.setMatchResult(vo.getChipNo().equals(dogBirthCertificate.getIdentificationFlag()));
					respList.add(resp);
				} else {
					Dog dog = dogDao.get(dogNose.getDogId());
					resp.setSort("TOP" + (i + 1));
					resp.setChipNo(dog.getIdentificationFlag());
					resp.setNoseId(obj.getNoseId());
					resp.setMatchResult(vo.getChipNo().equals(dog.getIdentificationFlag()));
					respList.add(resp);
				}
			} else {
				resp.setSort("TOP" + (i + 1));
				resp.setNoseId(obj.getNoseId());
				resp.setMatchResult(false);
				respList.add(resp);
			}
		}
//		matchChipNoListResponseVo.setChipNos(respList);
		return respList;
	}
}