package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹识别结果Entity
 * 
 * @author zhaoxy
 * @version 2020-11-30
 */
public class DogNoseResult extends DataEntity<DogNoseResult> {

	private static final long serialVersionUID = 1L;
	private String dogNose; // 鼻纹编号
	private String dogChip; // 芯片号
	private String noseType; // 识别类型 1: 1:1识别 2: 1:N识别
	private String deviceType; // 1: IOS 2:安卓
	private String deviceModel; // 设备型号
	private String clubCode; // 用户账号
	private String noseResult; // 识别结果 0:成功 1:失败
	private String successSort; // 1:n 成功次序
	private String noseResultInfo; // 1:n 信息

	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date

	public DogNoseResult() {
		super();
	}

	public DogNoseResult(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "鼻纹编号长度必须介于 0 和 64 之间")
	public String getDogNose() {
		return dogNose;
	}

	public void setDogNose(String dogNose) {
		this.dogNose = dogNose;
	}

	@Length(min = 0, max = 64, message = "芯片号长度必须介于 0 和 64 之间")
	public String getDogChip() {
		return dogChip;
	}

	public void setDogChip(String dogChip) {
		this.dogChip = dogChip;
	}

	@Length(min = 0, max = 1, message = "识别类型 1: 1:1识别 2: 1:N识别长度必须介于 0 和 1 之间")
	public String getNoseType() {
		return noseType;
	}

	public void setNoseType(String noseType) {
		this.noseType = noseType;
	}

	@Length(min = 0, max = 1, message = "1: IOS 2:安卓长度必须介于 0 和 1 之间")
	public String getDeviceType() {
		return deviceType;
	}

	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}

	@Length(min = 0, max = 32, message = "设备型号长度必须介于 0 和 32 之间")
	public String getDeviceModel() {
		return deviceModel;
	}

	public void setDeviceModel(String deviceModel) {
		this.deviceModel = deviceModel;
	}

	@Length(min = 0, max = 64, message = "用户账号长度必须介于 0 和 64 之间")
	public String getClubCode() {
		return clubCode;
	}

	public void setClubCode(String clubCode) {
		this.clubCode = clubCode;
	}

	@Length(min = 0, max = 1, message = "识别结果 0:成功 1:失败长度必须介于 0 和 1 之间")
	public String getNoseResult() {
		return noseResult;
	}

	public void setNoseResult(String noseResult) {
		this.noseResult = noseResult;
	}

	@Length(min = 0, max = 1, message = "1:n 成功次序长度必须介于 0 和 1 之间")
	public String getSuccessSort() {
		return successSort;
	}

	public void setSuccessSort(String successSort) {
		this.successSort = successSort;
	}

	@Length(min = 0, max = 128, message = "1:n 信息长度必须介于 0 和 128 之间")
	public String getNoseResultInfo() {
		return noseResultInfo;
	}

	public void setNoseResultInfo(String noseResultInfo) {
		this.noseResultInfo = noseResultInfo;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

}