/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹识别登记Entity
 * @author Sunny
 * @version 2021-04-14
 */
public class DogNoseCheckin extends DataEntity<DogNoseCheckin> {
	
	private static final long serialVersionUID = 1L;
	private String bizId;		// 业务ID
	private String bizType;		// 业务类型 10：出生纸，20：血统证书，30：血统证书整窝，40：犬只补录
	private String noseId;		// 鼻纹ID
	private String noseCode;		// 鼻纹编号
	private String deviceNumber;		// 设备号 HONORMOA-AL20,MT162CH/A
	private String devicePlatform;		// 设备平台 例如 Android IOS
	private String deviceModel;		// 设备型号 例如：Android：MOA-AL20；IOS：iPhone XS，iPhone XR
	private String deviceVersion;		// 设备系统版本 例如：Android：29，30；IOS：13.1，14.2
	private String deviceInformation;		// 设备其他信息
	private String operatorId;		// 操作人ID
	private String operatorCode;		// 操作人编号
	private Date operatorTime;		// 操作时间
	private String checkinStatus;		// 登记状态
	private String checkinFailReason;		// 登记失败原因
	private Date notifyTime;		// 通知时间
	
	public DogNoseCheckin() {
		super();
	}

	public DogNoseCheckin(String id){
		super(id);
	}

	@Length(min=0, max=64, message="业务ID长度必须介于 0 和 64 之间")
	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}
	
	@Length(min=0, max=10, message="业务类型 10：出生纸，20：血统证书，30：血统证书整窝，40：犬只补录长度必须介于 0 和 10 之间")
	public String getBizType() {
		return bizType;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}
	
	@Length(min=0, max=64, message="鼻纹ID长度必须介于 0 和 64 之间")
	public String getNoseId() {
		return noseId;
	}

	public void setNoseId(String noseId) {
		this.noseId = noseId;
	}
	
	@Length(min=0, max=64, message="鼻纹编号长度必须介于 0 和 64 之间")
	public String getNoseCode() {
		return noseCode;
	}

	public void setNoseCode(String noseCode) {
		this.noseCode = noseCode;
	}
	
	@Length(min=0, max=64, message="设备号 HONORMOA-AL20,MT162CH/A长度必须介于 0 和 64 之间")
	public String getDeviceNumber() {
		return deviceNumber;
	}

	public void setDeviceNumber(String deviceNumber) {
		this.deviceNumber = deviceNumber;
	}
	
	@Length(min=0, max=32, message="设备平台 例如 Android IOS长度必须介于 0 和 32 之间")
	public String getDevicePlatform() {
		return devicePlatform;
	}

	public void setDevicePlatform(String devicePlatform) {
		this.devicePlatform = devicePlatform;
	}
	
	@Length(min=0, max=32, message="设备型号 例如：Android：MOA-AL20；IOS：iPhone XS，iPhone XR长度必须介于 0 和 32 之间")
	public String getDeviceModel() {
		return deviceModel;
	}

	public void setDeviceModel(String deviceModel) {
		this.deviceModel = deviceModel;
	}
	
	@Length(min=0, max=32, message="32长度必须介于 0 和 32 之间")
	public String getDeviceVersion() {
		return deviceVersion;
	}

	public void setDeviceVersion(String deviceVersion) {
		this.deviceVersion = deviceVersion;
	}
	
	@Length(min=0, max=256, message="设备其他信息长度必须介于 0 和 256 之间")
	public String getDeviceInformation() {
		return deviceInformation;
	}

	public void setDeviceInformation(String deviceInformation) {
		this.deviceInformation = deviceInformation;
	}
	
	@Length(min=0, max=64, message="操作人ID长度必须介于 0 和 64 之间")
	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}
	
	@Length(min=0, max=64, message="操作人编号长度必须介于 0 和 64 之间")
	public String getOperatorCode() {
		return operatorCode;
	}

	public void setOperatorCode(String operatorCode) {
		this.operatorCode = operatorCode;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getOperatorTime() {
		return operatorTime;
	}

	public void setOperatorTime(Date operatorTime) {
		this.operatorTime = operatorTime;
	}
	
	@Length(min=0, max=64, message="登记状态长度必须介于 0 和 64 之间")
	public String getCheckinStatus() {
		return checkinStatus;
	}

	public void setCheckinStatus(String checkinStatus) {
		this.checkinStatus = checkinStatus;
	}
	
	@Length(min=0, max=64, message="登记失败原因长度必须介于 0 和 64 之间")
	public String getCheckinFailReason() {
		return checkinFailReason;
	}

	public void setCheckinFailReason(String checkinFailReason) {
		this.checkinFailReason = checkinFailReason;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getNotifyTime() {
		return notifyTime;
	}

	public void setNotifyTime(Date notifyTime) {
		this.notifyTime = notifyTime;
	}
	
}