/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只芯片会员锁定Entity
 * @author yuanshuai
 * @version 2021-03-02
 */
public class DogChipMemberLock extends DataEntity<DogChipMemberLock> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String identificationFlag;		// 身份识别标记
	private String lockState;		// 锁定状态（0为未锁定1为已锁定，默认为1）
	//显示用
	private String memberName;
	private String province;
	private String city;
	private String area;
	private String street;
	private String dogBreed;

	public DogChipMemberLock() {
		super();
	}

	public DogChipMemberLock(String id){
		super(id);
	}

	@Length(min=1, max=64, message="会员号长度必须介于 1 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=64, message="身份识别标记长度必须介于 1 和 64 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}
	
	@Length(min=1, max=1, message="锁定状态（0为未锁定1为已锁定，默认为1）长度必须介于 1 和 1 之间")
	public String getLockState() {
		return lockState;
	}

	public void setLockState(String lockState) {
		this.lockState = lockState;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
}