/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.Set;

/**
 * 证书补做DAO接口
 *
 * @author lgl
 * @version 2016-08-11
 */
@MyBatisDao
public interface DogPedigreeCertifiedRedoDao extends CrudDao<DogPedigreeCertifiedRedo> {
	int listCount(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void review(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void updateDogTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void updateDogBirthCertificateTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void updateDogNewbornTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void updateShowResultsTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);
	
	void updateShowScoreRankingTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void updateChampionLoginTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	DogPedigreeCertifiedRedo getByCurrentPedigreeCertified(String currentPedigreeCertified);
	DogPedigreeCertifiedRedo getByOriginalPedigreeCertified(@Param("originalPedigreeCertified") String originalPedigreeCertified);
	DogPedigreeCertifiedRedo getByDogIdChangeType(@Param("dogId") String dogId);

	/**
	 *
	 * @Description：证书补做数据处理后对出生纸表中的血统证书号进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月19日 上午9:39:57
	 */
	void updateDogNewbornPedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	/**
	 *
	 * @Description：证书补做数据处理后对犬只鉴定表中的血统证书号进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月19日 上午9:39:57
	 */
	void updateDogAppraisalPedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

	void refundDogpedigreecertifiedredo(@Param("vo") DogPedigreeCertifiedRedo vo, @Param("ids") Set<String> ids);
	
	//DNA存档表更新证书号
	Integer updateDogDnaArchiveTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);
	//血样留存表更新证书号
	Integer updateDogBloodSaveTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);
	//双亲对比表更新证书号
	Integer updateDogDnaParentsCompareTablePedigreeCertifiedCode(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo);

}