/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogChipChange;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

import java.util.Date;
import java.util.List;

/**
 * 芯片变更管理DAO接口
 * @author zhuoHeng
 * @version 2016-10-14
 */
@MyBatisDao
public interface DogChipChangeDao extends CrudDao<DogChipChange> {

	/**
	 * 根据芯片查询
	 * @Author chaixueteng
	 * @2016年10月12日下午4:05:19
	 */
	DogChipChange getByIdentificationFlag(@Param("chipCodeNew")String chipCodeNew);

	/**
	 * 新生犬物理删除
	 * @Author chaixueteng
	 * @2016年10月24日下午8:45:35
	 */
	void deleteYes(DogChipChange byIdentificationFlag);

	/**
	 * @description: 获取未缴费，未生成订单，犬只id为空的记录(地方俱乐部提交新生犬登记，但未生成订单的记录)
	 * @author: laiguanglong
	 * @date: 2016/12/21 14:43
	 */
	List<DogChipChange> getDogChipChangeNoOrder(@Param("date")Date date);

	/**
	 * @description: 获取芯片变更业务表记录关联的已缴费订单数量
	 * @author: laiguanglong
	 * @date: 2016/12/21 14:43
	 */
	int getPayedDogChipChangeOrderCount(@Param("id")String id);

	/**
	 * 根据国外证书号查询芯片变更记录
	 * @param overseasPedigreeCertified
	 * @author: chaixueteng
	 * @date: 2017/05/18 14:43
	 */
	DogChipChange getByOverseasPedigreeCertified(String overseasPedigreeCertified);
	/**
	 * 根据赛场鉴定编号查询芯片变更记录
	 * @author: chaixueteng
	 * @date: 2017/05/18 14:43
	 */
	DogChipChange getByShowAppraisalCode(@Param("showAppraisalCode")String showAppraisalCode);
}